/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.util;

import java.io.IOException;
import java.nio.file.attribute.PosixFilePermission;
import java.util.HashSet;
import java.util.Set;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class FileUnixPermissionUtil$ {
    public static final FileUnixPermissionUtil$ MODULE$ = new FileUnixPermissionUtil$();

    public Set<PosixFilePermission> getPosixPermissionsFromMode(int mode) {
        String numeric = Integer.toOctalString(mode);
        if (numeric != null && numeric.length() > 3) {
            numeric = numeric.substring(numeric.length() - 3);
        }
        HashSet<PosixFilePermission> result = new HashSet<PosixFilePermission>();
        int shortMode = Integer.parseInt(numeric, 8);
        Object object = (shortMode & 0x100) == 256 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OWNER_READ)) : BoxedUnit.UNIT;
        Object object2 = (shortMode & 0x80) == 128 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OWNER_WRITE)) : BoxedUnit.UNIT;
        Object object3 = (shortMode & 0x40) == 64 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OWNER_EXECUTE)) : BoxedUnit.UNIT;
        Object object4 = (shortMode & 0x20) == 32 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.GROUP_READ)) : BoxedUnit.UNIT;
        Object object5 = (shortMode & 0x10) == 16 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.GROUP_WRITE)) : BoxedUnit.UNIT;
        Object object6 = (shortMode & 8) == 8 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.GROUP_EXECUTE)) : BoxedUnit.UNIT;
        Object object7 = (shortMode & 4) == 4 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OTHERS_READ)) : BoxedUnit.UNIT;
        Object object8 = (shortMode & 2) == 2 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OTHERS_WRITE)) : BoxedUnit.UNIT;
        Object object9 = (shortMode & 1) == 1 ? BoxesRunTime.boxToBoolean((boolean)result.add(PosixFilePermission.OTHERS_EXECUTE)) : BoxedUnit.UNIT;
        return result;
    }

    public int getFilePermissionsAsInt(Set<PosixFilePermission> permissions) throws IOException {
        int unixFilePermissions;
        block8: {
            unixFilePermissions = 0;
            if (permissions.contains((Object)PosixFilePermission.OWNER_READ)) {
                unixFilePermissions |= 0x100;
            }
            if (permissions.contains((Object)PosixFilePermission.OWNER_WRITE)) {
                unixFilePermissions |= 0x80;
            }
            if (permissions.contains((Object)PosixFilePermission.OWNER_EXECUTE)) {
                unixFilePermissions |= 0x40;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_READ)) {
                unixFilePermissions |= 0x20;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_WRITE)) {
                unixFilePermissions |= 0x10;
            }
            if (permissions.contains((Object)PosixFilePermission.GROUP_EXECUTE)) {
                unixFilePermissions |= 8;
            }
            if (permissions.contains((Object)PosixFilePermission.OTHERS_READ)) {
                unixFilePermissions |= 4;
            }
            if (permissions.contains((Object)PosixFilePermission.OTHERS_WRITE)) {
                unixFilePermissions |= 2;
            }
            if (!permissions.contains((Object)PosixFilePermission.OTHERS_EXECUTE)) break block8;
            unixFilePermissions |= 1;
        }
        return unixFilePermissions;
    }

    private FileUnixPermissionUtil$() {
    }
}

