/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.validation.method;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import org.springframework.context.MessageSourceResolvable;
import org.springframework.validation.method.DefaultMethodValidationResult;
import org.springframework.validation.method.EmptyMethodValidationResult;
import org.springframework.validation.method.ParameterErrors;
import org.springframework.validation.method.ParameterValidationResult;

public interface MethodValidationResult {
    public Object getTarget();

    public Method getMethod();

    public boolean isForReturnValue();

    default public boolean hasErrors() {
        return !this.getParameterValidationResults().isEmpty();
    }

    default public List<? extends MessageSourceResolvable> getAllErrors() {
        return this.getParameterValidationResults().stream().flatMap(result -> result.getResolvableErrors().stream()).toList();
    }

    public List<ParameterValidationResult> getParameterValidationResults();

    @Deprecated(since="6.2", forRemoval=true)
    default public List<ParameterValidationResult> getAllValidationResults() {
        return this.getParameterValidationResults();
    }

    default public List<ParameterValidationResult> getValueResults() {
        return this.getParameterValidationResults().stream().filter(result -> !(result instanceof ParameterErrors)).toList();
    }

    default public List<ParameterErrors> getBeanResults() {
        return this.getParameterValidationResults().stream().filter(ParameterErrors.class::isInstance).map(result -> (ParameterErrors)result).toList();
    }

    public List<MessageSourceResolvable> getCrossParameterValidationResults();

    public static MethodValidationResult create(Object target, Method method, List<ParameterValidationResult> results) {
        return MethodValidationResult.create(target, method, results, Collections.emptyList());
    }

    public static MethodValidationResult create(Object target, Method method, List<ParameterValidationResult> results, List<MessageSourceResolvable> crossParameterErrors) {
        return new DefaultMethodValidationResult(target, method, results, crossParameterErrors);
    }

    public static MethodValidationResult emptyResult() {
        return new EmptyMethodValidationResult();
    }
}

