/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.client.jaxrs.internal;

import jakarta.ws.rs.core.Configuration;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.jboss.resteasy.client.jaxrs.api.ClientBuilderConfiguration;
import org.jboss.resteasy.client.jaxrs.internal.ResteasyClientBuilderImpl;

class DefaultClientBuilderConfiguration
implements ClientBuilderConfiguration {
    private final long connectionTTL;
    private final List<String> sniHostNames;
    private final String proxyHostName;
    private final int proxyPort;
    private final String proxyScheme;
    private final boolean cookieManagementEnabled;
    private final SSLContext sslContext;
    private final long readTimeout;
    private final long connectionTimeout;
    private final boolean isFollowRedirect;
    private final ExecutorService executorService;
    private final ScheduledExecutorService scheduledExecutorService;
    private final Configuration configuration;

    DefaultClientBuilderConfiguration(ResteasyClientBuilderImpl builder) {
        this.connectionTTL = builder.getConnectionTTL(TimeUnit.MILLISECONDS);
        this.sniHostNames = List.copyOf(builder.getSniHostNames());
        this.proxyHostName = builder.getDefaultProxyHostname();
        this.proxyPort = builder.getDefaultProxyPort();
        this.proxyScheme = builder.getDefaultProxyScheme();
        this.cookieManagementEnabled = builder.isCookieManagementEnabled();
        this.sslContext = builder.getSSLContext();
        this.readTimeout = builder.getReadTimeout(TimeUnit.MILLISECONDS);
        this.connectionTimeout = builder.getConnectionTimeout(TimeUnit.MILLISECONDS);
        this.isFollowRedirect = builder.isFollowRedirects();
        this.executorService = builder.asyncExecutor;
        this.scheduledExecutorService = builder.scheduledExecutorService;
        this.configuration = builder.getConfiguration();
    }

    static DefaultClientBuilderConfiguration create(ResteasyClientBuilderImpl builder) {
        return new DefaultClientBuilderConfiguration(builder);
    }

    public long connectionIdleTime(TimeUnit unit) {
        return this.connectionTTL;
    }

    public List<String> sniHostNames() {
        return this.sniHostNames;
    }

    public String defaultProxyHostname() {
        return this.proxyHostName;
    }

    public int defaultProxyPort() {
        return this.proxyPort;
    }

    public String defaultProxyScheme() {
        return this.proxyScheme;
    }

    public boolean isCookieManagementEnabled() {
        return this.cookieManagementEnabled;
    }

    public SSLContext sslContext() {
        return this.sslContext;
    }

    public long readTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.readTimeout, unit);
    }

    public long connectionTimeout(TimeUnit unit) {
        return TimeUnit.MILLISECONDS.convert(this.connectionTimeout, unit);
    }

    public boolean isFollowRedirects() {
        return this.isFollowRedirect;
    }

    public Optional<ExecutorService> executorService() {
        return Optional.ofNullable(this.executorService);
    }

    public Optional<ScheduledExecutorService> scheduledExecutorService() {
        return Optional.ofNullable(this.scheduledExecutorService);
    }

    public Configuration configuration() {
        return this.configuration;
    }
}

