/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.util;

import com.xebialabs.overthere.OverthereExecutionOutputHandler;
import org.slf4j.Logger;

public class LoggingOverthereExecutionOutputHandler
implements OverthereExecutionOutputHandler {
    private Logger logger;
    private LogLevel level;

    private LoggingOverthereExecutionOutputHandler(Logger logger, LogLevel level) {
        this.logger = logger;
        this.level = level;
    }

    @Override
    public void handleChar(char c) {
    }

    @Override
    public void handleLine(String line) {
        this.level.log(this.logger, line);
    }

    public static LoggingOverthereExecutionOutputHandler loggingOutputHandler(Logger logger) {
        return new LoggingOverthereExecutionOutputHandler(logger, LogLevel.INFO);
    }

    public static LoggingOverthereExecutionOutputHandler loggingErrorHandler(Logger logger) {
        return new LoggingOverthereExecutionOutputHandler(logger, LogLevel.ERROR);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    private static enum LogLevel {
        INFO{

            @Override
            void log(Logger logger, String message) {
                logger.info(message);
            }
        }
        ,
        ERROR{

            @Override
            void log(Logger logger, String message) {
                logger.error(message);
            }
        };


        abstract void log(Logger var1, String var2);
    }
}

