/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.CallingConvention;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.python.core.PyObject;
import org.python.modules.jffi.CType;
import org.python.modules.jffi.Invoker;
import org.python.modules.jffi.JITHandle;
import org.python.modules.jffi.JITSignature;
import org.python.modules.jffi.NativeType;

class JITCompiler {
    private final Map<JITSignature, HandleRef> handles = new HashMap<JITSignature, HandleRef>();
    private final Map<Class, JITHandle> classes = Collections.synchronizedMap(new WeakHashMap());
    private final ReferenceQueue referenceQueue = new ReferenceQueue();
    private final JITHandle failedHandle = new JITHandle(this, new JITSignature(NativeType.VOID, new NativeType[0], false, new boolean[0], CallingConvention.DEFAULT, false), true);

    JITCompiler() {
    }

    public static JITCompiler getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private void cleanup() {
        HandleRef ref;
        while ((ref = (HandleRef)this.referenceQueue.poll()) != null) {
            this.handles.remove(ref.signature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    JITHandle getHandle(PyObject resultType, PyObject[] parameterTypes, CallingConvention convention, boolean ignoreErrno) {
        boolean hasResultConverter;
        boolean bl = hasResultConverter = !(resultType instanceof CType.Builtin);
        if (!(resultType instanceof CType.Builtin)) {
            return this.failedHandle;
        }
        NativeType nativeResultType = ((CType)resultType).getNativeType();
        NativeType[] nativeParameterTypes = new NativeType[parameterTypes.length];
        boolean[] hasParameterConverter = new boolean[parameterTypes.length];
        for (int i = 0; i < hasParameterConverter.length; ++i) {
            CType parameterType = CType.typeOf(parameterTypes[i]);
            if (!(parameterType instanceof CType.Builtin)) {
                return this.failedHandle;
            }
            nativeParameterTypes[i] = parameterType.getNativeType();
            hasParameterConverter[i] = !(parameterType instanceof CType.Builtin);
        }
        JITSignature jitSignature = new JITSignature(nativeResultType, nativeParameterTypes, hasResultConverter, hasParameterConverter, convention, ignoreErrno);
        JITCompiler jITCompiler = this;
        synchronized (jITCompiler) {
            JITHandle handle;
            this.cleanup();
            HandleRef ref = this.handles.get(jitSignature);
            JITHandle jITHandle = handle = ref != null ? (JITHandle)ref.get() : null;
            if (handle == null) {
                handle = new JITHandle(this, jitSignature, false);
                this.handles.put(jitSignature, new HandleRef(handle, jitSignature, this.referenceQueue));
            }
            return handle;
        }
    }

    void registerClass(JITHandle handle, Class<? extends Invoker> klass) {
        this.classes.put(klass, handle);
    }

    private static class SingletonHolder {
        private static final JITCompiler INSTANCE = new JITCompiler();

        private SingletonHolder() {
        }
    }

    private static final class HandleRef
    extends WeakReference<JITHandle> {
        JITSignature signature;

        public HandleRef(JITHandle handle, JITSignature signature, ReferenceQueue refqueue) {
            super(handle, refqueue);
            this.signature = signature;
        }
    }
}

