/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.io;

import java.nio.ByteBuffer;
import org.apache.pekko.io.BufferPool;
import org.apache.pekko.io.DirectByteBufferPool$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005a3Q\u0001E\t\u0001'eA\u0001\u0002\n\u0001\u0003\u0002\u0003\u0006IA\n\u0005\tS\u0001\u0011\t\u0011)A\u0005M!)!\u0006\u0001C\u0001W!1q\u0006\u0001Q\u0001\nABaa\u000f\u0001!B\u00131\u0003\"\u0002\u001f\u0001\t\u0003i\u0004\"\u0002 \u0001\t\u0003y\u0004\"B#\u0001\t\u00131\u0005\"B%\u0001\t\u001bi\u0004\"\u0002&\u0001\t\u001bY\u0005\"B'\u0001\t\u001bquAB)\u0012\u0011\u0003\u0019\"K\u0002\u0004\u0011#!\u00051c\u0015\u0005\u0006U5!\t\u0001\u0016\u0005\u0006\u001b6!\t!\u0016\u0002\u0015\t&\u0014Xm\u0019;CsR,')\u001e4gKJ\u0004vn\u001c7\u000b\u0005I\u0019\u0012AA5p\u0015\t!R#A\u0003qK.\\wN\u0003\u0002\u0017/\u00051\u0011\r]1dQ\u0016T\u0011\u0001G\u0001\u0004_J<7c\u0001\u0001\u001bAA\u00111DH\u0007\u00029)\tQ$A\u0003tG\u0006d\u0017-\u0003\u0002 9\t1\u0011I\\=SK\u001a\u0004\"!\t\u0012\u000e\u0003EI!aI\t\u0003\u0015\t+hMZ3s!>|G.A\teK\u001a\fW\u000f\u001c;Ck\u001a4WM]*ju\u0016\u001c\u0001\u0001\u0005\u0002\u001cO%\u0011\u0001\u0006\b\u0002\u0004\u0013:$\u0018AD7bqB{w\u000e\\#oiJLWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00071jc\u0006\u0005\u0002\"\u0001!)Ae\u0001a\u0001M!)\u0011f\u0001a\u0001M\u0005!\u0001o\\8m!\rY\u0012gM\u0005\u0003eq\u0011Q!\u0011:sCf\u0004\"\u0001N\u001d\u000e\u0003UR!AN\u001c\u0002\u00079LwNC\u00019\u0003\u0011Q\u0017M^1\n\u0005i*$A\u0003\"zi\u0016\u0014UO\u001a4fe\u0006i!-\u001e4gKJ\u001c\u0018J\u001c)p_2\fq!Y2rk&\u0014X\rF\u00014\u0003\u001d\u0011X\r\\3bg\u0016$\"\u0001Q\"\u0011\u0005m\t\u0015B\u0001\"\u001d\u0005\u0011)f.\u001b;\t\u000b\u0011;\u0001\u0019A\u001a\u0002\u0007\t,h-\u0001\u0005bY2|7-\u0019;f)\t\u0019t\tC\u0003I\u0011\u0001\u0007a%\u0001\u0003tSj,\u0017A\u0005;bW\u0016\u0014UO\u001a4fe\u001a\u0013x.\u001c)p_2\f\u0011c\u001c4gKJ\u0014UO\u001a4feR{\u0007k\\8m)\t\u0001E\nC\u0003E\u0015\u0001\u00071'\u0001\ruef\u001cE.Z1o\t&\u0014Xm\u0019;CsR,')\u001e4gKJ$\"\u0001Q(\t\u000bA[\u0001\u0019A\u001a\u0002\u001bQ|')\u001a#fgR\u0014x._3e\u0003Q!\u0015N]3di\nKH/\u001a\"vM\u001a,'\u000fU8pYB\u0011\u0011%D\n\u0003\u001bi!\u0012A\u0015\u000b\u0003\u0001ZCQaV\bA\u0002M\n!BY=uK\n+hMZ3s\u0001")
public class DirectByteBufferPool
implements BufferPool {
    private final int defaultBufferSize;
    private final int maxPoolEntries;
    private final ByteBuffer[] pool;
    private int buffersInPool;

    @Override
    public ByteBuffer acquire() {
        return this.takeBufferFromPool();
    }

    @Override
    public void release(ByteBuffer buf) {
        this.offerBufferToPool(buf);
    }

    private ByteBuffer allocate(int size) {
        return ByteBuffer.allocateDirect(size);
    }

    private final ByteBuffer takeBufferFromPool() {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            ByteBuffer byteBuffer;
            if (this.buffersInPool > 0) {
                --this.buffersInPool;
                byteBuffer = this.pool[this.buffersInPool];
            } else {
                byteBuffer = null;
            }
            ByteBuffer byteBuffer2 = byteBuffer;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            if (byteBuffer2 == null) {
                return ByteBuffer.allocateDirect(this.defaultBufferSize);
            }
            byteBuffer2.clear();
            return byteBuffer2;
        }
    }

    private final void offerBufferToPool(ByteBuffer buf) {
        ByteBuffer[] byteBufferArray = this.pool;
        synchronized (this.pool) {
            boolean bl;
            if (this.buffersInPool < this.maxPoolEntries) {
                this.pool[this.buffersInPool] = buf;
                ++this.buffersInPool;
                bl = false;
            } else {
                bl = true;
            }
            boolean bl2 = bl;
            // ** MonitorExit[var2_2] (shouldn't be in output)
            if (bl2) {
                DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(buf);
                return;
            }
            return;
        }
    }

    private final void tryCleanDirectByteBuffer(ByteBuffer toBeDestroyed) {
        DirectByteBufferPool$.MODULE$.tryCleanDirectByteBuffer(toBeDestroyed);
    }

    public DirectByteBufferPool(int defaultBufferSize, int maxPoolEntries) {
        this.defaultBufferSize = defaultBufferSize;
        this.maxPoolEntries = maxPoolEntries;
        this.pool = new ByteBuffer[maxPoolEntries];
        this.buffersInPool = 0;
    }
}

