/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import com.kenai.jffi.Platform;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.NativeMemory;
import org.python.modules.jffi.Util;

public final class HeapMemory
implements Memory {
    protected static final ArrayIO IO = HeapMemory.getArrayIO();
    protected static final int LONG_SIZE = Platform.getPlatform().longSize() / 8;
    protected static final int ADDRESS_SIZE = Platform.getPlatform().addressSize() / 8;
    protected final byte[] buffer;
    protected final int offset;
    protected final int length;

    public HeapMemory(byte[] buffer, int offset, int length) {
        this.buffer = buffer;
        this.offset = offset;
        this.length = length;
    }

    public HeapMemory(int size) {
        this(new byte[size], 0, size);
    }

    private final void checkBounds(long off, long len) {
        Util.checkBounds(this.arrayLength(), off, len);
    }

    public final byte[] array() {
        return this.buffer;
    }

    public final int arrayOffset() {
        return this.offset;
    }

    public final int arrayLength() {
        return this.length;
    }

    private static final ArrayIO getArrayIO() {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return Platform.getPlatform().addressSize() == 64 ? HeapMemory.newBE64ArrayIO() : HeapMemory.newBE32ArrayIO();
        }
        return Platform.getPlatform().addressSize() == 64 ? HeapMemory.newLE64ArrayIO() : HeapMemory.newLE32ArrayIO();
    }

    private static final ArrayIO newBE64ArrayIO() {
        return new BE64ArrayIO();
    }

    private static final ArrayIO newBE32ArrayIO() {
        return new BE32ArrayIO();
    }

    private static final ArrayIO newLE64ArrayIO() {
        return new LE64ArrayIO();
    }

    private static final ArrayIO newLE32ArrayIO() {
        return new LE32ArrayIO();
    }

    protected final int index(long off) {
        return this.offset + (int)off;
    }

    @Override
    public final boolean isNull() {
        return false;
    }

    @Override
    public final boolean isDirect() {
        return false;
    }

    @Override
    public HeapMemory slice(long offset) {
        this.checkBounds(offset, 1L);
        return offset == 0L ? this : new HeapMemory(this.array(), this.arrayOffset() + (int)offset, this.arrayLength() - (int)offset);
    }

    @Override
    public final DirectMemory getMemory(long offset) {
        this.checkBounds(offset, ADDRESS_SIZE);
        long ptr = this.getAddress(offset);
        return ptr != 0L ? new NativeMemory(ptr) : null;
    }

    @Override
    public final void putAddress(long offset, Memory value) {
        this.checkBounds(offset, ADDRESS_SIZE);
        this.putAddress(offset, ((DirectMemory)value).getAddress());
    }

    @Override
    public final byte getByte(long offset) {
        this.checkBounds(offset, 1L);
        return (byte)(this.buffer[this.index(offset)] & 0xFF);
    }

    @Override
    public final short getShort(long offset) {
        this.checkBounds(offset, 2L);
        return IO.getInt16(this.buffer, this.index(offset));
    }

    @Override
    public final int getInt(long offset) {
        this.checkBounds(offset, 4L);
        return IO.getInt32(this.buffer, this.index(offset));
    }

    @Override
    public final long getLong(long offset) {
        this.checkBounds(offset, 8L);
        return IO.getInt64(this.buffer, this.index(offset));
    }

    @Override
    public final long getNativeLong(long offset) {
        return LONG_SIZE == 4 ? (long)this.getInt(offset) : this.getLong(offset);
    }

    @Override
    public final float getFloat(long offset) {
        this.checkBounds(offset, 4L);
        return IO.getFloat32(this.buffer, this.index(offset));
    }

    @Override
    public final double getDouble(long offset) {
        this.checkBounds(offset, 8L);
        return IO.getFloat64(this.buffer, this.index(offset));
    }

    @Override
    public final long getAddress(long offset) {
        this.checkBounds(offset, ADDRESS_SIZE);
        return IO.getAddress(this.buffer, this.index(offset));
    }

    @Override
    public final byte[] getZeroTerminatedByteArray(long offset) {
        this.checkBounds(offset, 1L);
        int len = this.indexOf(offset, (byte)0);
        byte[] bytes = new byte[len != -1 ? len : this.length - (int)offset];
        System.arraycopy(this.buffer, this.index(offset), bytes, 0, bytes.length);
        return bytes;
    }

    @Override
    public final void putByte(long offset, byte value) {
        this.checkBounds(offset, 1L);
        this.buffer[this.index((long)offset)] = value;
    }

    @Override
    public final void putShort(long offset, short value) {
        this.checkBounds(offset, 2L);
        IO.putInt16(this.buffer, this.index(offset), value);
    }

    @Override
    public final void putInt(long offset, int value) {
        this.checkBounds(offset, 4L);
        IO.putInt32(this.buffer, this.index(offset), value);
    }

    @Override
    public final void putLong(long offset, long value) {
        this.checkBounds(offset, 8L);
        IO.putInt64(this.buffer, this.index(offset), value);
    }

    @Override
    public final void putNativeLong(long offset, long value) {
        if (LONG_SIZE == 4) {
            this.putInt(offset, (int)value);
        } else {
            this.putLong(offset, value);
        }
    }

    @Override
    public final void putFloat(long offset, float value) {
        this.checkBounds(offset, 4L);
        IO.putFloat32(this.buffer, this.index(offset), value);
    }

    @Override
    public final void putDouble(long offset, double value) {
        this.checkBounds(offset, 8L);
        IO.putFloat64(this.buffer, this.index(offset), value);
    }

    @Override
    public final void putAddress(long offset, long value) {
        this.checkBounds(offset, ADDRESS_SIZE);
        IO.putAddress(this.buffer, this.index(offset), value);
    }

    @Override
    public void putZeroTerminatedByteArray(long offset, byte[] bytes, int off, int len) {
        this.checkBounds(offset, len + 1);
        System.arraycopy(bytes, off, this.buffer, this.index(offset), len);
        this.buffer[len] = 0;
    }

    @Override
    public final void get(long offset, byte[] dst, int off, int len) {
        this.checkBounds(offset, len);
        System.arraycopy(this.buffer, this.index(offset), dst, off, len);
    }

    @Override
    public final void put(long offset, byte[] src, int off, int len) {
        this.checkBounds(offset, len);
        System.arraycopy(src, off, this.buffer, this.index(offset), len);
    }

    @Override
    public final void get(long offset, short[] dst, int off, int len) {
        this.checkBounds(offset, len << 1);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt16(this.buffer, begin + (i << 1));
        }
    }

    @Override
    public final void put(long offset, short[] src, int off, int len) {
        this.checkBounds(offset, len << 1);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt16(this.buffer, begin + (i << 1), src[off + i]);
        }
    }

    @Override
    public final void get(long offset, int[] dst, int off, int len) {
        this.checkBounds(offset, len << 2);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt32(this.buffer, begin + (i << 2));
        }
    }

    @Override
    public final void put(long offset, int[] src, int off, int len) {
        this.checkBounds(offset, len << 2);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt32(this.buffer, begin + (i << 2), src[off + i]);
        }
    }

    @Override
    public final void get(long offset, long[] dst, int off, int len) {
        this.checkBounds(offset, len << 3);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getInt64(this.buffer, begin + (i << 3));
        }
    }

    @Override
    public final void put(long offset, long[] src, int off, int len) {
        this.checkBounds(offset, len << 3);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putInt64(this.buffer, begin + (i << 3), src[off + i]);
        }
    }

    @Override
    public final void get(long offset, float[] dst, int off, int len) {
        this.checkBounds(offset, len << 2);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getFloat32(this.buffer, begin + (i << 2));
        }
    }

    @Override
    public final void put(long offset, float[] src, int off, int len) {
        this.checkBounds(offset, len << 2);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putFloat32(this.buffer, begin + (i << 2), src[off + i]);
        }
    }

    @Override
    public final void get(long offset, double[] dst, int off, int len) {
        this.checkBounds(offset, len << 3);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            dst[off + i] = IO.getFloat64(this.buffer, begin + (i << 3));
        }
    }

    @Override
    public final void put(long offset, double[] src, int off, int len) {
        this.checkBounds(offset, len << 3);
        int begin = this.index(offset);
        for (int i = 0; i < len; ++i) {
            IO.putFloat64(this.buffer, begin + (i << 3), src[off + i]);
        }
    }

    @Override
    public final int indexOf(long offset, byte value) {
        int off = this.index(offset);
        for (int i = 0; i < this.length; ++i) {
            if (this.buffer[off + i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final int indexOf(long offset, byte value, int maxlen) {
        int off = this.index(offset);
        for (int i = 0; i < Math.min(this.length, maxlen); ++i) {
            if (this.buffer[off + i] != value) continue;
            return i;
        }
        return -1;
    }

    @Override
    public final void setMemory(long offset, long size, byte value) {
        this.checkBounds(offset, size);
        Arrays.fill(this.buffer, this.index(offset), (int)size, value);
    }

    public final void clear() {
        Arrays.fill(this.buffer, this.offset, this.length, (byte)0);
    }

    protected static abstract class ArrayIO {
        protected ArrayIO() {
        }

        public abstract short getInt16(byte[] var1, int var2);

        public abstract int getInt32(byte[] var1, int var2);

        public abstract long getInt64(byte[] var1, int var2);

        public abstract long getAddress(byte[] var1, int var2);

        public abstract void putInt16(byte[] var1, int var2, int var3);

        public abstract void putInt32(byte[] var1, int var2, int var3);

        public abstract void putInt64(byte[] var1, int var2, long var3);

        public abstract void putAddress(byte[] var1, int var2, long var3);

        public final float getFloat32(byte[] buffer, int offset) {
            return Float.intBitsToFloat(this.getInt32(buffer, offset));
        }

        public final void putFloat32(byte[] buffer, int offset, float value) {
            this.putInt32(buffer, offset, Float.floatToRawIntBits(value));
        }

        public final double getFloat64(byte[] buffer, int offset) {
            return Double.longBitsToDouble(this.getInt64(buffer, offset));
        }

        public final void putFloat64(byte[] buffer, int offset, double value) {
            this.putInt64(buffer, offset, Double.doubleToRawLongBits(value));
        }
    }

    private static final class BE64ArrayIO
    extends BigEndianArrayIO {
        private BE64ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset) {
            return this.getInt64(buffer, offset);
        }

        @Override
        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class BE32ArrayIO
    extends BigEndianArrayIO {
        private BE32ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset) {
            return (long)this.getInt32(buffer, offset) & 0xFFFFFFFFL;
        }

        @Override
        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt32(buffer, offset, (int)value);
        }
    }

    private static final class LE64ArrayIO
    extends LittleEndianArrayIO {
        private LE64ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset) {
            return this.getInt64(buffer, offset);
        }

        @Override
        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt64(buffer, offset, value);
        }
    }

    private static final class LE32ArrayIO
    extends LittleEndianArrayIO {
        private LE32ArrayIO() {
        }

        @Override
        public final long getAddress(byte[] buffer, int offset) {
            return (long)this.getInt32(buffer, offset) & 0xFFFFFFFFL;
        }

        @Override
        public final void putAddress(byte[] buffer, int offset, long value) {
            this.putInt32(buffer, offset, (int)value);
        }
    }

    private static abstract class BigEndianArrayIO
    extends ArrayIO {
        private BigEndianArrayIO() {
        }

        @Override
        public short getInt16(byte[] array, int offset) {
            return (short)((array[offset + 0] & 0xFF) << 8 | array[offset + 1] & 0xFF);
        }

        @Override
        public int getInt32(byte[] array, int offset) {
            return (array[offset + 0] & 0xFF) << 24 | (array[offset + 1] & 0xFF) << 16 | (array[offset + 2] & 0xFF) << 8 | (array[offset + 3] & 0xFF) << 0;
        }

        @Override
        public long getInt64(byte[] array, int offset) {
            return ((long)array[offset + 0] & 0xFFL) << 56 | ((long)array[offset + 1] & 0xFFL) << 48 | ((long)array[offset + 2] & 0xFFL) << 40 | ((long)array[offset + 3] & 0xFFL) << 32 | ((long)array[offset + 4] & 0xFFL) << 24 | ((long)array[offset + 5] & 0xFFL) << 16 | ((long)array[offset + 6] & 0xFFL) << 8 | ((long)array[offset + 7] & 0xFFL) << 0;
        }

        @Override
        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 8);
            buffer[offset + 1] = (byte)(value >> 0);
        }

        @Override
        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 24);
            buffer[offset + 1] = (byte)(value >> 16);
            buffer[offset + 2] = (byte)(value >> 8);
            buffer[offset + 3] = (byte)(value >> 0);
        }

        @Override
        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 56);
            buffer[offset + 1] = (byte)(value >> 48);
            buffer[offset + 2] = (byte)(value >> 40);
            buffer[offset + 3] = (byte)(value >> 32);
            buffer[offset + 4] = (byte)(value >> 24);
            buffer[offset + 5] = (byte)(value >> 16);
            buffer[offset + 6] = (byte)(value >> 8);
            buffer[offset + 7] = (byte)(value >> 0);
        }
    }

    private static abstract class LittleEndianArrayIO
    extends ArrayIO {
        private LittleEndianArrayIO() {
        }

        @Override
        public final short getInt16(byte[] array, int offset) {
            return (short)(array[offset] & 0xFF | (array[offset + 1] & 0xFF) << 8);
        }

        @Override
        public final int getInt32(byte[] array, int offset) {
            return (array[offset + 0] & 0xFF) << 0 | (array[offset + 1] & 0xFF) << 8 | (array[offset + 2] & 0xFF) << 16 | (array[offset + 3] & 0xFF) << 24;
        }

        @Override
        public final long getInt64(byte[] array, int offset) {
            return ((long)array[offset + 0] & 0xFFL) << 0 | ((long)array[offset + 1] & 0xFFL) << 8 | ((long)array[offset + 2] & 0xFFL) << 16 | ((long)array[offset + 3] & 0xFFL) << 24 | ((long)array[offset + 4] & 0xFFL) << 32 | ((long)array[offset + 5] & 0xFFL) << 40 | ((long)array[offset + 6] & 0xFFL) << 48 | ((long)array[offset + 7] & 0xFFL) << 56;
        }

        @Override
        public final void putInt16(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
        }

        @Override
        public final void putInt32(byte[] buffer, int offset, int value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
        }

        @Override
        public final void putInt64(byte[] buffer, int offset, long value) {
            buffer[offset + 0] = (byte)(value >> 0);
            buffer[offset + 1] = (byte)(value >> 8);
            buffer[offset + 2] = (byte)(value >> 16);
            buffer[offset + 3] = (byte)(value >> 24);
            buffer[offset + 4] = (byte)(value >> 32);
            buffer[offset + 5] = (byte)(value >> 40);
            buffer[offset + 6] = (byte)(value >> 48);
            buffer[offset + 7] = (byte)(value >> 56);
        }
    }
}

