/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.plugin.stitch.service;

import com.fasterxml.jackson.databind.JsonNode;
import com.xebialabs.deployit.core.rest.view.InvocationDescriptorView;
import com.xebialabs.deployit.core.rest.view.InvocationDiffView;
import com.xebialabs.deployit.core.rest.view.PreviewResult;
import com.xebialabs.deployit.engine.api.dto.ChangeSetDto;
import com.xebialabs.deployit.engine.api.dto.DryRunDeploymentDto;
import com.xebialabs.deployit.plugin.api.flow.ExecutionContext;
import com.xebialabs.deployit.plugin.api.flow.Step;
import com.xebialabs.deployit.plugin.stitch.dao.jpa.configuration.TransactionalStitchService;
import com.xebialabs.deployit.plugin.stitch.model.Namespace;
import com.xebialabs.deployit.plugin.stitch.model.Namespace$;
import com.xebialabs.deployit.plugin.stitch.model.Processor;
import com.xebialabs.deployit.plugin.stitch.model.RuleCondition;
import com.xebialabs.deployit.plugin.stitch.model.RuleCondition$;
import com.xebialabs.deployit.plugin.stitch.model.Specification;
import com.xebialabs.deployit.plugin.stitch.model.StitchContent;
import com.xebialabs.deployit.plugin.stitch.model.StitchContent$;
import com.xebialabs.deployit.plugin.stitch.model.StitchDefinition;
import com.xebialabs.deployit.plugin.stitch.model.ci.GitSource;
import com.xebialabs.deployit.plugin.stitch.model.parameter.MacroParameter;
import com.xebialabs.deployit.plugin.stitch.model.parameter.MacroParameter$;
import com.xebialabs.deployit.plugin.stitch.model.parameter.MacroProcessorParameter;
import com.xebialabs.deployit.plugin.stitch.model.parameter.ProcessorParameter;
import com.xebialabs.deployit.plugin.stitch.model.parameter.RuleProcessorParameter;
import com.xebialabs.deployit.plugin.stitch.model.processor.MacroProcessor;
import com.xebialabs.deployit.plugin.stitch.model.processor.RuleProcessor;
import com.xebialabs.deployit.plugin.stitch.model.specification.Macro;
import com.xebialabs.deployit.plugin.stitch.model.specification.Rule;
import com.xebialabs.deployit.plugin.stitch.service.ChangeSet;
import com.xebialabs.deployit.plugin.stitch.service.DryRunInvocation;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors;
import com.xebialabs.deployit.plugin.stitch.service.DryRunProcessors$;
import com.xebialabs.deployit.plugin.stitch.service.DryRunService;
import com.xebialabs.deployit.plugin.stitch.service.GitService;
import com.xebialabs.deployit.plugin.stitch.service.ProcessorDiff;
import com.xebialabs.deployit.plugin.stitch.service.StitchPreviewFailedException;
import com.xebialabs.deployit.plugin.stitch.service.StitchRulesConverter;
import com.xebialabs.deployit.plugin.stitch.service.StitchTaskSpecificationService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.ParallelSyncOccurredException;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.SourceSyncService;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.RepositoryCrawler$StitchRepositoryLoadException$;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.crawler.parser.SnippetRange;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.ParametersDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.ProcessorDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.RuleSpecDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.index.dto.StitchDefinitionDTO;
import com.xebialabs.deployit.plugin.stitch.service.engine.util.TextDiffFinder$;
import com.xebialabs.deployit.plugin.stitch.service.util.PreviewUtils$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.RandomUtils;
import org.slf4j.Marker;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.LinearSeqOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.mutable.ListBuffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@Service
@Autowired
@TransactionalStitchService
@ScalaSignature(bytes="\u0006\u0005\t\u001dh\u0001\u0002\r\u001a\u0001\u0019B\u0001\"\u000f\u0001\u0003\u0002\u0003\u0006IA\u000f\u0005\t{\u0001\u0011\t\u0011)A\u0005}!A\u0011\t\u0001B\u0001B\u0003%!\t\u0003\u0005K\u0001\t\u0005\t\u0015!\u0003L\u0011\u0015q\u0005\u0001\"\u0001P\u0011\u0015)\u0006\u0001\"\u0003W\u0011\u0015q\b\u0001\"\u0003\u0000\u0011\u001d\ti\u0002\u0001C\u0005\u0003?Aq!a\u0012\u0001\t\u0013\tI\u0005C\u0004\u0002`\u0001!\t!!\u0019\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x!9\u0011Q\u0011\u0001\u0005\n\u0005\u001d\u0005bBA]\u0001\u0011%\u00111\u0018\u0005\b\u0003K\u0004A\u0011BAt\u0011\u001d\tY\u0010\u0001C\u0005\u0003{DqA!\u0004\u0001\t\u0013\u0011y\u0001C\u0004\u0003\u001e\u0001!IAa\b\t\u000f\t\u0005\u0003\u0001\"\u0003\u0003D!A!q\t\u0001\u0005\u0002e\u0011I\u0005C\u0004\u0003N\u0001!\tEa\u0014\t\u000f\t\r\u0004\u0001\"\u0001\u0003f!9!1\u000e\u0001\u0005B\t5\u0004b\u0002BD\u0001\u0011\u0005#\u0011\u0012\u0002\u0012\tJL(+\u001e8TKJ4\u0018nY3J[Bd'B\u0001\u000e\u001c\u0003\u001d\u0019XM\u001d<jG\u0016T!\u0001H\u000f\u0002\rM$\u0018\u000e^2i\u0015\tqr$\u0001\u0004qYV<\u0017N\u001c\u0006\u0003A\u0005\n\u0001\u0002Z3qY>L\u0018\u000e\u001e\u0006\u0003E\r\n\u0011\u0002_3cS\u0006d\u0017MY:\u000b\u0003\u0011\n1aY8n\u0007\u0001\u0019B\u0001A\u0014.cA\u0011\u0001fK\u0007\u0002S)\t!&A\u0003tG\u0006d\u0017-\u0003\u0002-S\t1\u0011I\\=SK\u001a\u0004\"AL\u0018\u000e\u0003eI!\u0001M\r\u0003\u001b\u0011\u0013\u0018PU;o'\u0016\u0014h/[2f!\t\u0011t'D\u00014\u0015\t!T'A\u0003tY\u001a$$NC\u00017\u0003!9'/\u001b>{Y\u0016$\u0017B\u0001\u001d4\u0005\u001daunZ4j]\u001e\fad\u001d;ji\u000eDG+Y:l'B,7-\u001b4jG\u0006$\u0018n\u001c8TKJ4\u0018nY3\u0011\u00059Z\u0014B\u0001\u001f\u001a\u0005y\u0019F/\u001b;dQR\u000b7o[*qK\u000eLg-[2bi&|gnU3sm&\u001cW-\u0001\u000bti&$8\r\u001b*vY\u0016\u001c8i\u001c8wKJ$XM\u001d\t\u0003]}J!\u0001Q\r\u0003)M#\u0018\u000e^2i%VdWm]\"p]Z,'\u000f^3s\u0003E\u0019x.\u001e:dKNKhnY*feZL7-\u001a\t\u0003\u0007\"k\u0011\u0001\u0012\u0006\u0003\u000b\u001a\u000bQ!\u001b8eKbT!aR\r\u0002\r\u0015tw-\u001b8f\u0013\tIEIA\tT_V\u00148-Z*z]\u000e\u001cVM\u001d<jG\u0016\f!bZ5u'\u0016\u0014h/[2f!\tqC*\u0003\u0002N3\tQq)\u001b;TKJ4\u0018nY3\u0002\rqJg.\u001b;?)\u0015\u0001\u0016KU*U!\tq\u0003\u0001C\u0003:\u000b\u0001\u0007!\bC\u0003>\u000b\u0001\u0007a\bC\u0003B\u000b\u0001\u0007!\tC\u0003K\u000b\u0001\u00071*A\thKR\u0014V\u000f\\3D_:$\u0017\u000e^5p]N$BaV5rmB\u0019\u0001\fY2\u000f\u0005esfB\u0001.^\u001b\u0005Y&B\u0001/&\u0003\u0019a$o\\8u}%\t!&\u0003\u0002`S\u00059\u0001/Y2lC\u001e,\u0017BA1c\u0005\u0011a\u0015n\u001d;\u000b\u0005}K\u0003C\u00013h\u001b\u0005)'B\u00014\u001c\u0003\u0015iw\u000eZ3m\u0013\tAWMA\u0007Sk2,7i\u001c8eSRLwN\u001c\u0005\u0006U\u001a\u0001\ra[\u0001\u000feVdW\rR3gS:LG/[8o!\taw.D\u0001n\u0015\tqG)A\u0002ei>L!\u0001]7\u0003\u0017I+H.Z*qK\u000e$Ek\u0014\u0005\u0006e\u001a\u0001\ra]\u0001\tg>,(oY3JIB\u0011\u0001\u0006^\u0005\u0003k&\u00121!\u00138u\u0011\u00159h\u00011\u0001y\u0003\u0011\u0011X\u000f\\3\u0011\u0005edX\"\u0001>\u000b\u0005m,\u0017!D:qK\u000eLg-[2bi&|g.\u0003\u0002~u\n!!+\u001e7f\u0003I9W\r^'bGJ|\u0007+\u0019:b[\u0016$XM]:\u0015\u0011\u0005\u0005\u0011qBA\t\u0003'\u0001B\u0001\u00171\u0002\u0004A!\u0011QAA\u0006\u001b\t\t9AC\u0002\u0002\n\u0015\f\u0011\u0002]1sC6,G/\u001a:\n\t\u00055\u0011q\u0001\u0002\u000f\u001b\u0006\u001c'o\u001c)be\u0006lW\r^3s\u0011\u0015Qw\u00011\u0001l\u0011\u0015\u0011x\u00011\u0001t\u0011\u001d\t)b\u0002a\u0001\u0003/\t1\"\\1de>$U\r^1jYB\u0019\u00110!\u0007\n\u0007\u0005m!PA\u0003NC\u000e\u0014x.A\fhKR\u0004\u0016M]1nKR,'oV5uQ\u000e{g\u000e^3oiR!\u0011\u0011EA\u001f!!\t\u0019#a\u000b\u00022\u0005]b\u0002BA\u0013\u0003O\u0001\"AW\u0015\n\u0007\u0005%\u0012&\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003[\tyCA\u0002NCBT1!!\u000b*!\u0011\t\u0019#a\r\n\t\u0005U\u0012q\u0006\u0002\u0007'R\u0014\u0018N\\4\u0011\u00071\fI$C\u0002\u0002<5\u0014Q\u0002U1sC6,G/\u001a:t\tR{\u0005bBA \u0011\u0001\u0007\u0011\u0011I\u0001\naJ|7-Z:t_J\u00042\u0001\\A\"\u0013\r\t)%\u001c\u0002\r!J|7-Z:t_J$EkT\u0001\u0014M&dG\u000e\u0015:pG\u0016\u001c8o\u001c:GS\u0016dGm\u001d\u000b\t\u0003\u0017\n\t&a\u0015\u0002VA\u0019\u0001&!\u0014\n\u0007\u0005=\u0013F\u0001\u0003V]&$\b\"\u0002:\n\u0001\u0004\u0019\bbBA \u0013\u0001\u0007\u0011\u0011\t\u0005\b\u0003/J\u0001\u0019AA-\u00039\u0019\u0018M^3e!J|7-Z:t_J\u00042\u0001ZA.\u0013\r\ti&\u001a\u0002\n!J|7-Z:t_J\f\u0001cZ3u%VdW\r\u0015:pG\u0016\u001c8o\u001c:\u0015\u0011\u0005\r\u0014QNA8\u0003c\u0002B!!\u001a\u0002j5\u0011\u0011q\r\u0006\u0004\u0003\u007f)\u0017\u0002BA6\u0003O\u0012QBU;mKB\u0013xnY3tg>\u0014\b\"B<\u000b\u0001\u0004A\bbBA \u0015\u0001\u0007\u0011\u0011\t\u0005\u0007\u0003gR\u0001\u0019A:\u0002\u0003%\f\u0011cZ3u\u001b\u0006\u001c'o\u001c)s_\u000e,7o]8s)!\tI(a \u0002\u0002\u0006\r\u0005\u0003BA3\u0003wJA!! \u0002h\tqQ*Y2s_B\u0013xnY3tg>\u0014\bbBA\u000b\u0017\u0001\u0007\u0011q\u0003\u0005\b\u0003\u007fY\u0001\u0019AA!\u0011\u0019\t\u0019h\u0003a\u0001g\u0006)\u0002/\u0019:tKN#\u0018\u000e^2i\t\u00164\u0017N\\5uS>tGCCAE\u0003\u001f\u000b\u0019*a(\u00026B\u0019a&a#\n\u0007\u00055\u0015D\u0001\tEef\u0014VO\u001c)s_\u000e,7o]8sg\"9\u0011\u0011\u0013\u0007A\u0002\u0005E\u0012\u0001B=b[2Dq!!&\r\u0001\u0004\t9*\u0001\u000bti&$8\r\u001b#fM&t\u0017\u000e^5p]N$Eo\u001c\t\u00051\u0002\fI\nE\u0002m\u00037K1!!(n\u0005M\u0019F/\u001b;dQ\u0012+g-\u001b8ji&|g\u000e\u0012+P\u0011\u001d\t\t\u000b\u0004a\u0001\u0003G\u000bQ\u0002]1sg\u0016\u00148i\u001c8uKb$\b\u0003CA\u0012\u0003W\t\t$!*\u0011\t\u0005\u001d\u0016\u0011W\u0007\u0003\u0003SSA!a+\u0002.\u00061\u0001/\u0019:tKJT1!a,E\u0003\u001d\u0019'/Y<mKJLA!a-\u0002*\na1K\\5qa\u0016$(+\u00198hK\"9\u0011q\u0017\u0007A\u0002\u0005%\u0015aD1eI>s\u0007K]8dKN\u001cxN]:\u0002/\u001d,G\u000f\u0015:pG\u0016\u001c8o\u001c:Ta\u0016\u001cG)\u001a;bS2\u001cH\u0003EAE\u0003{\u000b\t-a3\u0002V\u0006]\u0017\u0011\\Ar\u0011\u001d\ty,\u0004a\u0001\u00033\u000b\u0001c\u001d;ji\u000eDG)\u001a4j]&$\u0018n\u001c8\t\u000f\u0005\rW\u00021\u0001\u0002F\u0006QA-\u001a4j]&$\u0018n\u001c8\u0011\u0007\u0011\f9-C\u0002\u0002J\u0016\u0014\u0001c\u0015;ji\u000eDG)\u001a4j]&$\u0018n\u001c8\t\u000f\u00055W\u00021\u0001\u0002P\u0006Ia.Y7fgB\f7-\u001a\t\u0004I\u0006E\u0017bAAjK\nIa*Y7fgB\f7-\u001a\u0005\b\u0003Ck\u0001\u0019AAR\u0011\u0015\u0011X\u00021\u0001t\u0011\u001d\tY.\u0004a\u0001\u0003;\fQb\u001d;ji\u000eD7i\u001c8uK:$\bc\u00013\u0002`&\u0019\u0011\u0011]3\u0003\u001bM#\u0018\u000e^2i\u0007>tG/\u001a8u\u0011\u001d\t9,\u0004a\u0001\u0003\u0013\u000b\u0011cZ3u%VdW\rR3gS:LG/[8o)9\tI/a<\u0002r\u0006M\u0018Q_A|\u0003s\u00042\u0001ZAv\u0013\r\ti/\u001a\u0002\u000e'B,7-\u001b4jG\u0006$\u0018n\u001c8\t\u000f\u0005\u0005f\u00021\u0001\u0002$\")!O\u0004a\u0001g\"9\u00111\u001c\bA\u0002\u0005u\u0007bBAg\u001d\u0001\u0007\u0011q\u001a\u0005\b\u0003\u0007t\u0001\u0019AAc\u0011\u0015Qg\u00021\u0001l\u0003I9W\r^'bGJ|\u0007K]8dKN\u001cxN]:\u0015\u0015\u0005}(1\u0001B\u0003\u0005\u000f\u0011I\u0001\u0005\u0005\u0002$\u0005-\u0012\u0011\u0007B\u0001!\u0011A\u0006-!\u001f\t\u000bI|\u0001\u0019A:\t\u000b)|\u0001\u0019A6\t\u000f\u0005Uq\u00021\u0001\u0002\u0018!9!1B\bA\u0002\u0005}\u0018!E7bGJ|\u0007K]8dKN\u001cxN]'ba\u0006\tr-\u001a;Sk2,\u0007K]8dKN\u001cxN]:\u0015\u0015\tE!1\u0003B\u000b\u0005/\u0011I\u0002\u0005\u0003YA\u0006\r\u0004\"\u0002:\u0011\u0001\u0004\u0019\b\"\u00026\u0011\u0001\u0004Y\u0007\"B<\u0011\u0001\u0004A\bb\u0002B\u000e!\u0001\u0007!\u0011C\u0001\u0012eVdW\r\u0015:pG\u0016\u001c8o\u001c:MSN$\u0018\u0001D4fi\u000eC\u0017M\\4f'\u0016$H\u0003\u0002B\u0011\u0005[\u0001R\u0001\u000bB\u0012\u0005OI1A!\n*\u0005\u0019y\u0005\u000f^5p]B\u0019aF!\u000b\n\u0007\t-\u0012DA\u0005DQ\u0006tw-Z*fi\"9!qF\tA\u0002\tE\u0012a\u00053ssJ+h\u000eR3qY>LX.\u001a8u\tR|\u0007\u0003\u0002B\u001a\u0005{i!A!\u000e\u000b\u00079\u00149D\u0003\u0003\u0003:\tm\u0012aA1qS*\u0011qiH\u0005\u0005\u0005\u007f\u0011)DA\nEef\u0014VO\u001c#fa2|\u00170\\3oi\u0012#x.\u0001\u000bts:\u001c'I]1oG\"\u0014V\r]8tSR|'/\u001f\u000b\u0005\u0003\u0017\u0012)\u0005C\u0004\u00030I\u0001\rA!\r\u0002-\u001d,G\u000f\u0015:pG\u0016\u001c8o\u001c:t\r>\u0014HI]=Sk:$B!!#\u0003L!9!qF\nA\u0002\tE\u0012!\u0004<bY&$\u0017\r^3Sk2,7\u000f\u0006\u0003\u0003R\t}\u0003C\u0002B*\u0005;\n\t$\u0004\u0002\u0003V)!!q\u000bB-\u0003\u0011)H/\u001b7\u000b\u0005\tm\u0013\u0001\u00026bm\u0006L1!\u0019B+\u0011\u001d\u0011\t\u0007\u0006a\u0001\u0005#\n1b\u001d;ji\u000eD'+\u001e7fg\u0006\u0011b/\u00197jI\u0006$XM\u0011:b]\u000eDg*Y7f)\u0011\tYEa\u001a\t\u000f\t%T\u00031\u0001\u0003\"\u0005I1\r[1oO\u0016\u001cV\r^\u0001\u000eaJ,g/[3x\tJL(+\u001e8\u0015\t\t=$1\u0011\t\u0005\u0005c\u0012y(\u0004\u0002\u0003t)!!Q\u000fB<\u0003\u00111\u0018.Z<\u000b\t\te$1P\u0001\u0005e\u0016\u001cHOC\u0002\u0003~}\tAaY8sK&!!\u0011\u0011B:\u00055\u0001&/\u001a<jK^\u0014Vm];mi\"9!Q\u0011\fA\u0002\tE\u0012\u0001\u00053ssJ+h\u000eR3qY>LX.\u001a8u\u0003m\u0001(/\u001a<jK^$%/\u001f*v]^KG\u000f\u001b\"sK\u0006\\\u0007o\\5oiRQ!1\u0012BI\u0005+\u0013IJa)\u0011\t\tE$QR\u0005\u0005\u0005\u001f\u0013\u0019H\u0001\nJ]Z|7-\u0019;j_:$\u0015N\u001a4WS\u0016<\bb\u0002BJ/\u0001\u0007\u0011\u0011G\u0001\rI\u0016\u0004Hn\\=fI:\u000bW.\u001a\u0005\u0007\u0005/;\u0002\u0019A:\u0002\u001f%tgo\\2bi&|g.\u00138eKbDqAa'\u0018\u0001\u0004\u0011i*\u0001\u0006ce\u0016\f7\u000e]8j]R\u0004BAa\u0015\u0003 &!!\u0011\u0015B+\u0005\u0011)V+\u0013#\t\u000f\t\u0015u\u00031\u0001\u00032!\u001a\u0001Aa*\u0011\t\t%&qW\u0007\u0003\u0005WSAA!,\u00030\u0006i1m\u001c8gS\u001e,(/\u0019;j_:TAA!-\u00034\u0006\u0019!\u000e]1\u000b\u0007\tU6$A\u0002eC>LAA!/\u0003,\nQBK]1og\u0006\u001cG/[8oC2\u001cF/\u001b;dQN+'O^5dK\"\u001a\u0001A!0\u0011\t\t}&Q[\u0007\u0003\u0005\u0003TAAa1\u0003F\u0006Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\u000b\t\t\u001d'\u0011Z\u0001\bM\u0006\u001cGo\u001c:z\u0015\u0011\u0011YM!4\u0002\u000b\t,\u0017M\\:\u000b\t\t='\u0011[\u0001\u0010gB\u0014\u0018N\\4ge\u0006lWm^8sW*\u0011!1[\u0001\u0004_J<\u0017\u0002\u0002Bl\u0005\u0003\u0014\u0011\"Q;u_^L'/\u001a3)\u0007\u0001\u0011Y\u000e\u0005\u0003\u0003^\n\rXB\u0001Bp\u0015\u0011\u0011\tO!4\u0002\u0015M$XM]3pif\u0004X-\u0003\u0003\u0003f\n}'aB*feZL7-\u001a")
public class DryRunServiceImpl
implements DryRunService,
Logging {
    private final StitchTaskSpecificationService stitchTaskSpecificationService;
    private final StitchRulesConverter stitchRulesConverter;
    private final SourceSyncService sourceSyncService;
    private final GitService gitService;
    private transient Logger grizzled$slf4j$Logging$$_logger;
    private volatile transient boolean bitmap$trans$0;

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        DryRunServiceImpl dryRunServiceImpl = this;
        synchronized (dryRunServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!this.bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return this.grizzled$slf4j$Logging$$_logger;
    }

    private List<RuleCondition> getRuleConditions(RuleSpecDTO ruleDefinition, int sourceId, Rule rule) {
        ListBuffer ruleConditionList = new ListBuffer();
        ruleDefinition.condition().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String conditionKey = (String)tuple2._1();
                String conditionValue = (String)tuple2._2();
                RuleCondition ruleCondition = RuleCondition$.MODULE$.apply(sourceId, rule, conditionKey, conditionValue);
                ruleCondition.id_$eq(UUID.randomUUID());
                return (ListBuffer)ruleConditionList.$plus$eq((Object)ruleCondition);
            }
            throw new MatchError((Object)tuple2);
        });
        return ruleConditionList.toList();
    }

    private List<MacroParameter> getMacroParameters(RuleSpecDTO ruleDefinition, int sourceId, Macro macroDetail) {
        ListBuffer macroParameterList = new ListBuffer();
        ruleDefinition.parameters().foreach((Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 != null) {
                String parameterKey = (String)tuple2._1();
                String parameterValue = (String)tuple2._2();
                MacroParameter macroParamter = MacroParameter$.MODULE$.apply(sourceId, macroDetail, parameterKey, parameterValue);
                macroParamter.id_$eq(UUID.randomUUID());
                return (ListBuffer)macroParameterList.$plus$eq((Object)macroParamter);
            }
            throw new MatchError((Object)tuple2);
        });
        return macroParameterList.toList();
    }

    private scala.collection.immutable.Map<String, ParametersDTO> getParameterWithContent(ProcessorDTO processor) {
        return (scala.collection.immutable.Map)processor.parameters().transform((Function2 & Serializable)(x$1, value) -> new ParametersDTO((JsonNode)value, null, null));
    }

    private void fillProcessorFields(int sourceId, ProcessorDTO processor, Processor savedProcessor) {
        List<ProcessorParameter> params = processor.parametersModel(sourceId, savedProcessor);
        savedProcessor.id_$eq(UUID.randomUUID());
        Processor processor2 = savedProcessor;
        if (processor2 instanceof RuleProcessor) {
            RuleProcessor ruleProcessor = (RuleProcessor)processor2;
            List ruleProcessorParameter = params.map((Function1 & Serializable)x0$1 -> {
                ProcessorParameter processorParameter = x0$1;
                if (processorParameter instanceof RuleProcessorParameter) {
                    RuleProcessorParameter ruleProcessorParameter = (RuleProcessorParameter)processorParameter;
                    return ruleProcessorParameter;
                }
                throw new MatchError((Object)processorParameter);
            });
            ruleProcessor.parameters_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)ruleProcessorParameter).asJava());
            return;
        }
        if (processor2 instanceof MacroProcessor) {
            MacroProcessor macroProcessor = (MacroProcessor)processor2;
            List macroProcessorParameter = params.map((Function1 & Serializable)x0$2 -> {
                ProcessorParameter processorParameter = x0$2;
                if (processorParameter instanceof MacroProcessorParameter) {
                    MacroProcessorParameter macroProcessorParameter = (MacroProcessorParameter)processorParameter;
                    return macroProcessorParameter;
                }
                throw new MatchError((Object)processorParameter);
            });
            macroProcessor.parameters_$eq(CollectionConverters$.MODULE$.SeqHasAsJava((Seq)macroProcessorParameter).asJava());
            return;
        }
        throw new MatchError((Object)processor2);
    }

    public RuleProcessor getRuleProcessor(Rule rule, ProcessorDTO processor, int i) {
        processor.parametersWithContent_$eq(this.getParameterWithContent(processor));
        Processor processor2 = processor.toModel(rule.sourceId(), rule.namespace(), rule.definition(), rule, i);
        if (!(processor2 instanceof RuleProcessor)) {
            throw new MatchError((Object)processor2);
        }
        RuleProcessor ruleProcessor = (RuleProcessor)processor2;
        RuleProcessor savedProcessor = ruleProcessor;
        this.fillProcessorFields(rule.sourceId(), processor, savedProcessor);
        savedProcessor.rule_$eq(rule);
        return savedProcessor;
    }

    public MacroProcessor getMacroProcessor(Macro macroDetail, ProcessorDTO processor, int i) {
        processor.parametersWithContent_$eq(this.getParameterWithContent(processor));
        Processor processor2 = processor.toModel(macroDetail.sourceId(), macroDetail.namespace(), macroDetail.definition(), macroDetail, i);
        if (!(processor2 instanceof MacroProcessor)) {
            throw new MatchError((Object)processor2);
        }
        MacroProcessor macroProcessor = (MacroProcessor)processor2;
        MacroProcessor savedMacroProcessor = macroProcessor;
        this.fillProcessorFields(macroDetail.sourceId(), processor, savedMacroProcessor);
        savedMacroProcessor.macro_$eq(macroDetail);
        return savedMacroProcessor;
    }

    private DryRunProcessors parseStitchDefinition(String yaml, List<StitchDefinitionDTO> stitchDefinitionsDto, scala.collection.immutable.Map<String, SnippetRange> parserContext, DryRunProcessors addOnProcessors) {
        int sourceId = RandomUtils.nextInt();
        StitchContent stitchContent = StitchContent$.MODULE$.apply(sourceId, null, "", yaml);
        return (DryRunProcessors)stitchDefinitionsDto.foldLeft((Object)addOnProcessors, (Function2 & Serializable)(addOnProcessor, stitchDef) -> {
            Namespace namespace = Namespace$.MODULE$.apply(stitchDef.namespace());
            namespace.id_$eq(UUID.randomUUID());
            StitchDefinition definition = stitchDef.toModel(sourceId, null, namespace, stitchContent);
            definition.id_$eq(UUID.randomUUID());
            return this.getProcessorSpecDetails((StitchDefinitionDTO)stitchDef, definition, namespace, parserContext, sourceId, stitchContent, (DryRunProcessors)addOnProcessor);
        });
    }

    private DryRunProcessors getProcessorSpecDetails(StitchDefinitionDTO stitchDefinition, StitchDefinition definition, Namespace namespace, scala.collection.immutable.Map<String, SnippetRange> parserContext, int sourceId, StitchContent stitchContent, DryRunProcessors addOnProcessors) {
        return (DryRunProcessors)stitchDefinition.spec().foldLeft((Object)addOnProcessors, (Function2 & Serializable)(addOnProcessor, ruleSpecProcessor) -> {
            Specification specification = this.getRuleDefinition(parserContext, sourceId, stitchContent, namespace, definition, (RuleSpecDTO)ruleSpecProcessor);
            Specification specification2 = specification;
            if (specification2 instanceof Rule) {
                Rule rule = (Rule)specification2;
                return new DryRunProcessors(this.getRuleProcessors(sourceId, (RuleSpecDTO)ruleSpecProcessor, rule, addOnProcessor.ruleProcessors()), addOnProcessor.macroProcessors());
            }
            if (specification2 instanceof Macro) {
                Macro macro = (Macro)specification2;
                return new DryRunProcessors(addOnProcessor.ruleProcessors(), this.getMacroProcessors(sourceId, (RuleSpecDTO)ruleSpecProcessor, macro, addOnProcessor.macroProcessors()));
            }
            throw new MatchError((Object)specification2);
        });
    }

    private Specification getRuleDefinition(scala.collection.immutable.Map<String, SnippetRange> parserContext, int sourceId, StitchContent stitchContent, Namespace namespace, StitchDefinition definition, RuleSpecDTO ruleDefinition) {
        return ruleDefinition.toModel(sourceId, (Option<String>)None$.MODULE$, namespace, definition, stitchContent, (SnippetRange)parserContext.getOrElse((Object)ruleDefinition.name(), (Function0 & Serializable)() -> {
            throw RepositoryCrawler$StitchRepositoryLoadException$.MODULE$.apply("Cannot find snippet range for specification " + ruleDefinition.name());
        }));
    }

    private scala.collection.immutable.Map<String, List<MacroProcessor>> getMacroProcessors(int sourceId, RuleSpecDTO ruleDefinition, Macro macroDetail, scala.collection.immutable.Map<String, List<MacroProcessor>> macroProcessorMap) {
        macroDetail.id_$eq(UUID.randomUUID());
        macroDetail.parameters_$eq(CollectionConverters$.MODULE$.SeqHasAsJava(this.getMacroParameters(ruleDefinition, sourceId, macroDetail)).asJava());
        String key = macroDetail.namespace().name() + "-" + macroDetail.name();
        return (scala.collection.immutable.Map)((LinearSeqOps)ruleDefinition.processor().zipWithIndex()).foldLeft(macroProcessorMap, (Function2 & Serializable)(macroMap, processor) -> {
            MacroProcessor savedMacroProcessor = this.getMacroProcessor(macroDetail, (ProcessorDTO)processor._1(), processor._2$mcI$sp());
            List macroList = (List)macroMap.getOrElse((Object)key, (Function0 & Serializable)() -> package$.MODULE$.List().empty());
            MacroProcessor macroProcessor = savedMacroProcessor;
            List finalMacroList = macroList.$colon$colon((Object)macroProcessor);
            return (scala.collection.immutable.Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)finalMacroList)}))).$plus$plus((IterableOnce)macroMap);
        });
    }

    private List<RuleProcessor> getRuleProcessors(int sourceId, RuleSpecDTO ruleDefinition, Rule rule, List<RuleProcessor> ruleProcessorList) {
        rule.id_$eq(UUID.randomUUID());
        rule.conditions_$eq(CollectionConverters$.MODULE$.SeqHasAsJava(this.getRuleConditions(ruleDefinition, sourceId, rule)).asJava());
        return (List)((LinearSeqOps)ruleDefinition.processor().zipWithIndex()).foldLeft(ruleProcessorList, (Function2 & Serializable)(processorList, processor) -> {
            RuleProcessor ruleProcessor = this.getRuleProcessor(rule, (ProcessorDTO)processor._1(), processor._2$mcI$sp());
            return processorList.$colon$colon((Object)ruleProcessor);
        });
    }

    private Option<ChangeSet> getChangeSet(DryRunDeploymentDto dryRunDeploymentDto) {
        Option<ChangeSetDto> option = dryRunDeploymentDto.changeSet();
        if (option instanceof Some) {
            Some some = (Some)option;
            ChangeSetDto changeSet = (ChangeSetDto)((Object)some.value());
            GitSource source = this.gitService.fetchGitSourceCi(changeSet.sourceId());
            return new Some((Object)new ChangeSet(source, changeSet.branchName()));
        }
        this.info((Function0<Object>)(Function0 & Serializable)() -> "Dry run has no change set defined");
        return None$.MODULE$;
    }

    private void syncBranchRepository(DryRunDeploymentDto dryRunDeploymentDto) {
        this.getChangeSet(dryRunDeploymentDto).foreach((Function1 & Serializable)changeSet -> {
            DryRunServiceImpl.$anonfun$syncBranchRepository$1(this, changeSet);
            return BoxedUnit.UNIT;
        });
    }

    public DryRunProcessors getProcessorsForDryRun(DryRunDeploymentDto dryRunDeploymentDto) {
        return (DryRunProcessors)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(dryRunDeploymentDto.stitchRulesYaml()).asScala().map((Function1 & Serializable)yaml -> $this.stitchRulesConverter.convert((String)yaml))).foldLeft((Object)new DryRunProcessors(DryRunProcessors$.MODULE$.apply$default$1(), DryRunProcessors$.MODULE$.apply$default$2()), (Function2 & Serializable)(addOnProcessor, stitchRule) -> this.parseStitchDefinition(stitchRule.content(), stitchRule.stitchDefinitions(), stitchRule.parserContext(), (DryRunProcessors)addOnProcessor));
    }

    @Override
    public java.util.List<String> validateRules(java.util.List<String> stitchRules) {
        return CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)CollectionConverters$.MODULE$.ListHasAsScala(stitchRules).asScala().flatMap((Function1 & Serializable)yaml -> {
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.stitchRulesConverter.convert((String)yaml));
            if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                return new Some((Object)exception.getMessage());
            }
            return None$.MODULE$;
        })).toList()).asJava();
    }

    public void validateBranchName(Option<ChangeSet> changeSet) {
        changeSet.foreach((Function1 & Serializable)set -> {
            this.gitService.validateBranch(set.source(), set.branchName());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public PreviewResult previewDryRun(DryRunDeploymentDto dryRunDeployment) {
        Option<ChangeSet> changeSet = this.getChangeSet(dryRunDeployment);
        this.validateBranchName(changeSet);
        this.syncBranchRepository(dryRunDeployment);
        DryRunProcessors addOnProcessors = this.getProcessorsForDryRun(dryRunDeployment);
        Map<String, java.util.List<InvocationDescriptorView>> deployedMap = PreviewUtils$.MODULE$.logDryRun((scala.collection.immutable.Map<String, java.util.List<InvocationDescriptorView>>)((IterableOnceOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.stitchTaskSpecificationService.previewDeploymentTaskDryRun(dryRunDeployment.deployment(), changeSet, addOnProcessors).getSteps()).asScala().map((Function1 & Serializable)x$2 -> x$2.getImplementation())).flatMap((Function1 & Serializable)x0$1 -> {
            Step step = x0$1;
            if (step instanceof DryRunInvocation) {
                DryRunInvocation dryRunInvocation = (DryRunInvocation)step;
                this.debug((Function0<Object>)(Function0 & Serializable)() -> "Found dry run preview on stitch invocation for " + dryRunInvocation.deployed().getName() + " with " + dryRunInvocation.processors().size() + " processors");
                return new Some((Object)dryRunInvocation);
            }
            return None$.MODULE$;
        })).toList().map((Function1 & Serializable)step -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)step.deployed().getId()), (Object)new InvocationDescriptorView(step.name(), step.source(), step.result(), TextDiffFinder$.MODULE$.textDiff(step.source(), step.result()), CollectionConverters$.MODULE$.SeqHasAsJava(PreviewUtils$.MODULE$.getProcessorViews(step.processors())).asJava(), CollectionConverters$.MODULE$.MapHasAsJava(step.errorProcessors()).asJava()))).groupBy((Function1 & Serializable)x$3 -> (String)x$3._1()).view().mapValues((Function1 & Serializable)invocation -> CollectionConverters$.MODULE$.SeqHasAsJava((Seq)invocation.map((Function1 & Serializable)i -> (InvocationDescriptorView)i._2())).asJava()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl()));
        return new PreviewResult(deployedMap);
    }

    @Override
    public InvocationDiffView previewDryRunWithBreakpoint(String deployedName, int invocationIndex, UUID breakpoint, DryRunDeploymentDto dryRunDeployment) {
        Option<ChangeSet> changeSet = this.getChangeSet(dryRunDeployment);
        if (changeSet.isDefined()) {
            Some some;
            ProcessorDiff diff;
            Option option = (Option)((IterableOnceOps)((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(this.stitchTaskSpecificationService.previewDeploymentTaskDryRun(dryRunDeployment.deployment(), changeSet, breakpoint, invocationIndex).getSteps()).asScala().map((Function1 & Serializable)x$4 -> x$4.getImplementation())).flatMap((Function1 & Serializable)x0$1 -> {
                Step step = x0$1;
                if (step instanceof ProcessorDiff) {
                    ProcessorDiff processorDiff = (ProcessorDiff)step;
                    return new Some((Object)processorDiff);
                }
                return None$.MODULE$;
            })).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)DryRunServiceImpl.$anonfun$previewDryRunWithBreakpoint$3(deployedName, x$5)))).toList().lift().apply((Object)BoxesRunTime.boxToInteger((int)invocationIndex));
            if (option instanceof Some && (diff = (ProcessorDiff)(some = (Some)option).value()) != null) {
                ProcessorDiff processorDiff = diff;
                this.info((Function0<Object>)(Function0 & Serializable)() -> "Found processor difference for deployed " + processorDiff.deployed().getName() + ", in invocation #" + invocationIndex + " for processorId: [" + breakpoint + "]");
                return new InvocationDiffView(processorDiff.current(), processorDiff.previous(), TextDiffFinder$.MODULE$.textDiff(processorDiff.current(), processorDiff.previous()));
            }
            throw new StitchPreviewFailedException("Error occurred while generating processors difference preview - processor not found");
        }
        throw new StitchPreviewFailedException("Dry run with breakpoint can only run against Change Set - define a Change Set and try again");
    }

    public static final /* synthetic */ void $anonfun$syncBranchRepository$1(DryRunServiceImpl $this, ChangeSet changeSet) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> $this.sourceSyncService.sync(changeSet.source(), (Option<String>)Option$.MODULE$.apply((Object)changeSet.branchName()), (Option<ExecutionContext>)None$.MODULE$));
        if (try_ instanceof Success) {
            $this.info((Function0<Object>)(Function0 & Serializable)() -> "Successfully synced " + changeSet.source().repositoryUrl() + " on branch " + changeSet.branchName());
            return;
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof ParallelSyncOccurredException) {
                throw new StitchPreviewFailedException("Dry run cannot run in same time as sync of branch - try again");
            }
        }
        if (bl) {
            Throwable e = failure.exception();
            throw new StitchPreviewFailedException("Dry run failed - check application logs: " + e.getMessage());
        }
        throw new MatchError((Object)try_);
    }

    public static final /* synthetic */ boolean $anonfun$previewDryRunWithBreakpoint$3(String deployedName$1, ProcessorDiff x$5) {
        String string = x$5.deployed().getName();
        String string2 = deployedName$1;
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public DryRunServiceImpl(StitchTaskSpecificationService stitchTaskSpecificationService, StitchRulesConverter stitchRulesConverter, SourceSyncService sourceSyncService, GitService gitService) {
        this.stitchTaskSpecificationService = stitchTaskSpecificationService;
        this.stitchRulesConverter = stitchRulesConverter;
        this.sourceSyncService = sourceSyncService;
        this.gitService = gitService;
        Logging.$init$((Logging)this);
    }
}

