/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers.multipart;

import java.io.IOException;
import java.io.InputStream;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.ext.Providers;
import org.apache.james.mime4j.dom.Multipart;
import org.apache.james.mime4j.dom.field.ContentTypeField;
import org.apache.james.mime4j.message.BodyPart;
import org.jboss.resteasy.plugins.providers.multipart.InputPart;
import org.jboss.resteasy.plugins.providers.multipart.MultipartInputImpl;
import org.jboss.resteasy.plugins.providers.multipart.MultipartRelatedInput;

public class MultipartRelatedInputImpl
extends MultipartInputImpl
implements MultipartRelatedInput {
    private Map<String, InputPart> relatedMap;
    private String start;
    private String startInfo;
    private String type;
    private InputPart rootPart;

    public MultipartRelatedInputImpl(MediaType contentType, Providers workers) {
        super(contentType, workers);
    }

    public MultipartRelatedInputImpl(Multipart multipart, Providers workers) throws IOException {
        super(multipart, workers);
    }

    @Override
    public void parse(InputStream is) throws IOException {
        super.parse(is);
        ContentTypeField contentTypeField = (ContentTypeField)this.mimeMessage.getHeader().getField("Content-Type");
        this.start = contentTypeField.getParameter("start");
        this.startInfo = contentTypeField.getParameter("start-info");
        this.type = contentTypeField.getParameter("type");
        this.rootPart = this.start == null ? this.getParts().get(0) : this.getRelatedMap().get(this.start);
    }

    @Override
    protected InputPart extractPart(BodyPart bodyPart) throws IOException {
        InputPart inputPart = super.extractPart(bodyPart);
        this.getRelatedMap().put((String)inputPart.getHeaders().getFirst((Object)"Content-ID"), inputPart);
        return inputPart;
    }

    @Override
    public Map<String, InputPart> getRelatedMap() {
        if (this.relatedMap == null) {
            this.relatedMap = new LinkedHashMap<String, InputPart>();
        }
        return this.relatedMap;
    }

    @Override
    public InputPart getRootPart() {
        return this.rootPart;
    }

    @Override
    public String getStart() {
        return this.start;
    }

    @Override
    public String getStartInfo() {
        return this.startInfo;
    }

    @Override
    public String getType() {
        return this.type;
    }
}

