package com.xebialabs.deployit.cli;

import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import java.util.HashMap;
import java.util.Map;

public class ScriptEngineBuilder {

    private final Map<String, Object> attributes = new HashMap<>();

    public ScriptEngine build() {
        final ScriptEngineManager engineManager = new ScriptEngineManager();
        final ScriptEngine jythonEngine = engineManager.getEngineByName("python");

        if (jythonEngine == null) {
            throw new IllegalStateException("Could not find the JythonEngine, is it on the classpath?");
        }

        registerAttributes(jythonEngine);
        return jythonEngine;
    }

    private void registerAttributes(ScriptEngine jythonEngine) {
        for (Map.Entry<String, Object> entry : attributes.entrySet()) {
            jythonEngine.put(entry.getKey(), entry.getValue());
        }
    }

    public void put(String name, Object value) {
        attributes.put(name, value);
    }
}
