/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.LangUtil;
import org.agrona.UnsafeAccess;

public final class BufferUtil {
    public static final byte[] NULL_BYTES = "null".getBytes(StandardCharsets.UTF_8);
    public static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    public static final long ARRAY_BASE_OFFSET = UnsafeAccess.UNSAFE.arrayBaseOffset(byte[].class);
    public static final long BYTE_BUFFER_HB_FIELD_OFFSET;
    public static final long BYTE_BUFFER_OFFSET_FIELD_OFFSET;
    public static final long BYTE_BUFFER_ADDRESS_FIELD_OFFSET;
    private static final MethodHandle INVOKE_CLEANER;
    private static final MethodHandle GET_CLEANER;
    private static final MethodHandle CLEAN;

    private BufferUtil() {
    }

    public static void boundsCheck(byte[] buffer, long index, int length) {
        int capacity = buffer.length;
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + capacity);
        }
    }

    public static void boundsCheck(ByteBuffer buffer, long index, int length) {
        int capacity = buffer.capacity();
        long resultingPosition = index + (long)length;
        if (index < 0L || resultingPosition > (long)capacity) {
            throw new IndexOutOfBoundsException("index=" + index + " length=" + length + " capacity=" + capacity);
        }
    }

    public static long address(ByteBuffer buffer) {
        if (!buffer.isDirect()) {
            throw new IllegalArgumentException("buffer.isDirect() must be true");
        }
        return UnsafeAccess.UNSAFE.getLong(buffer, BYTE_BUFFER_ADDRESS_FIELD_OFFSET);
    }

    public static byte[] array(ByteBuffer buffer) {
        if (buffer.isDirect()) {
            throw new IllegalArgumentException("buffer must wrap an array");
        }
        return (byte[])UnsafeAccess.UNSAFE.getObject(buffer, BYTE_BUFFER_HB_FIELD_OFFSET);
    }

    public static int arrayOffset(ByteBuffer buffer) {
        return UnsafeAccess.UNSAFE.getInt(buffer, BYTE_BUFFER_OFFSET_FIELD_OFFSET);
    }

    public static ByteBuffer allocateDirectAligned(int capacity, int alignment) {
        if (!BitUtil.isPowerOfTwo(alignment)) {
            throw new IllegalArgumentException("Must be a power of 2: alignment=" + alignment);
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(capacity + alignment);
        long address = BufferUtil.address(buffer);
        int remainder = (int)(address & (long)(alignment - 1));
        int offset = alignment - remainder;
        buffer.limit(capacity + offset);
        buffer.position(offset);
        return buffer.slice();
    }

    public static void free(DirectBuffer buffer) {
        if (null != buffer) {
            BufferUtil.free(buffer.byteBuffer());
        }
    }

    public static void free(ByteBuffer buffer) {
        if (null != buffer && buffer.isDirect()) {
            try {
                if (null != INVOKE_CLEANER) {
                    INVOKE_CLEANER.invokeExact(UnsafeAccess.UNSAFE, buffer);
                } else {
                    Object cleaner = GET_CLEANER.invoke(buffer);
                    if (null != cleaner) {
                        CLEAN.invoke(cleaner);
                    }
                }
            }
            catch (Throwable t) {
                LangUtil.rethrowUnchecked(t);
            }
        }
    }

    static {
        try {
            BYTE_BUFFER_HB_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("hb"));
            BYTE_BUFFER_OFFSET_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(ByteBuffer.class.getDeclaredField("offset"));
            BYTE_BUFFER_ADDRESS_FIELD_OFFSET = UnsafeAccess.UNSAFE.objectFieldOffset(Buffer.class.getDeclaredField("address"));
            MethodHandle invokeCleaner = null;
            MethodHandle getCleaner = null;
            MethodHandle clean = null;
            MethodHandles.Lookup lookup = MethodHandles.lookup();
            try {
                invokeCleaner = lookup.findVirtual(UnsafeAccess.UNSAFE.getClass(), "invokeCleaner", MethodType.methodType(Void.TYPE, ByteBuffer.class));
            }
            catch (NoSuchMethodException ex) {
                Class<?> directBuffer = Class.forName("sun.nio.ch.DirectBuffer");
                Class<?> cleaner = Class.forName("sun.misc.Cleaner");
                getCleaner = lookup.findVirtual(directBuffer, "cleaner", MethodType.methodType(cleaner));
                clean = lookup.findVirtual(cleaner, "clean", MethodType.methodType(Void.TYPE));
            }
            INVOKE_CLEANER = invokeCleaner;
            GET_CLEANER = getCleaner;
            CLEAN = clean;
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }
}

