package ai.digital.deploy.cache.service

import java.util
import javax.cache.Cache

class CacheWrapper[K,V](cache: Cache[K,V]) {

  def containsKey(key: K): Boolean = {
    cache.containsKey(key)
  }

  def get(key: K): V = {
    cache.get(key)
  }

  def put(key: K, value: V): Unit = {
    cache.put(key, value)
  }

  def remove(key: K): Boolean = {
    cache.remove(key)
  }

  def getAll: util.Map[K, V] = {
    val map = new util.HashMap[K, V]()
    cache.iterator().forEachRemaining(e => map.put(e.getKey, e.getValue))
    map
  }

  def getAll(keys: util.Set[_ <: K]): util.Map[K, V] = {
    cache.getAll(keys)
  }

  def putAll(entries: util.Map[_ <: K, _ <: V]): Unit = {
    cache.putAll(entries)
  }

  def removeAll(keys: util.Set[_ <: K]): Unit = {
    cache.removeAll(keys)
  }

  def removeAll(): Unit = {
    cache.removeAll()
  }

  def clear(): Unit = {
    cache.clear()
  }
}
