package ai.digital.deploy.cache.config

import ai.digital.configuration.central.deploy.{ClusterProperties, TaskerSystemProperties}
import com.xebialabs.xlplatform.cluster.ClusterMode.STANDALONE
import grizzled.slf4j.Logging
import org.springframework.beans.factory.annotation.Autowired
import org.springframework.stereotype.Component

import javax.annotation.PostConstruct

@Component
class CacheMode(@Autowired taskerSystemProperties: TaskerSystemProperties,
                @Autowired clusterProperties: ClusterProperties) extends Logging {

  @PostConstruct
  def setCacheMode(): Unit = {
    CacheMode.embeddedCacheMode = taskerSystemProperties.inProcessWorker &&
      clusterProperties.mode.equals(STANDALONE)
    logger.info(s"cache mode set to ${if (CacheMode.embeddedCacheMode) "embedded" else "standalone" }")
  }

}

object CacheMode {
  var embeddedCacheMode: Boolean = false
}
