package ai.digital.configuration.central.deploy.task

import com.fasterxml.jackson.annotation.JsonProperty

import scala.beans.BeanProperty

class SslProperties {

  /**
   * Path to the client_certificate
   */
  @BeanProperty
  @JsonProperty("key-store")
  var keyStore: String = _

  /**
   * Password for the key.
   *
   */
  @BeanProperty
  @JsonProperty("key-password")
  var keyPassword: String = _

  /**
   * Password for the keystore
   */
  @BeanProperty
  @JsonProperty("key-store-password")
  var keyStorePassword: String = _

  /**
   * SSL Protocol, For example: 'TLSv1.1', 'TLSv1.2', TLSv1.3
   */
  @BeanProperty
  @JsonProperty("protocol")
  var protocol: String = "TLSv1.3"

  /**
   * Path to the truststore
   */
  @BeanProperty
  @JsonProperty("trust-store")
  var trustStore: String = _

  /**
   * Password for the truststore
   */
  @BeanProperty
  @JsonProperty("trust-store-password")
  var trustStorePassword: String = _
}
