package ai.digital.configuration.central.deploy.server

import ai.digital.doc.properties.DocDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty

import java.util.{List => JList}
import scala.beans.BeanProperty

class GzipProperties {
  /**
   * Should be set to false to disable compression.
   *
   */
  @BeanProperty
  var enabled: Boolean = true

  /**
   * Set the minimum response size to trigger compression (in kB).
   *
   */
  @BeanProperty
  @JsonProperty("minSize")
  var minSize: Int = 10

  /**
   * Set the Compression level
   *
   */
  @BeanProperty
  @JsonProperty("compression")
  var compression: Int = 4

  /**
   * List of string paths that will be excluded from the compression
   *
   */
  @BeanProperty
  @JsonProperty("excludedPaths")
  @DocDefaultValue(value = "[]", removeQuote = true)
  var excludedPaths: JList[String] = JList.of()
}
