package ai.digital.configuration.central.deploy.server
import ai.digital.doc.properties.DocDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty

import java.util.{List => JList}
import scala.beans.BeanProperty

class AllowedHostsProperties {

  /**
    * Flag to enable whitelisting of hostnames
    */
  @BeanProperty
  @JsonProperty("enabled")
  @DocDefaultValue(value = "false", removeQuote = true)
  var enabled: Boolean = false;

  /**
    * List of hostnames to whitelist.
    * Any request to hosts outside of the list will be rejected.
    */
  @BeanProperty
  @JsonProperty("hostnames")
  @DocDefaultValue(value="[]", removeQuote = true)
  var hostnames: JList[String] = JList.of()
}
