package ai.digital.configuration.central.deploy.server

import com.fasterxml.jackson.annotation.JsonProperty

import scala.beans.BeanProperty

class CspProperties {

  /**
   * Enable or disable Content-Security-Policy in http request header
   *
   */
  @BeanProperty
  @JsonProperty("enabled")
  var enabled: Boolean = true

  /**
   * Content-Security-Policy header values
   *
   */
  @BeanProperty
  @JsonProperty("policyDirectives")
  var policyDirectives: String = "default-src 'self'; script-src 'self' 'unsafe-inline' 'unsafe-eval'; style-src 'self' 'unsafe-inline'; font-src 'self' data: blob: 'unsafe-inline'; img-src 'self' data: blob:; connect-src 'self'; frame-src 'self'; frame-ancestors 'self'; child-src 'self';"

}
