package ai.digital.configuration.central.deploy.db

import ai.digital.doc.properties.DocDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty

import scala.beans.BeanProperty

class Artifacts {

  /**
    * Should artifacts -found in other (not configured) storage options- be moved to the configured storage?
    * If the system detects artifact data in the database, but the storage type is configured as "file" or vice versa, this
    * setting is required to be true and the system will move the artifacts from the database/file storage to the
    * file/database storage.
    *
    */
  @BeanProperty
  @JsonProperty("allow-move")
  var allowMove: Boolean = false

  /**
    * Location for artifact storage on file system.
    * Only active when type = "file".
    *
    */
  @BeanProperty
  @DocDefaultValue(value="artifacts", removeQuote = false)
  var root: String = Artifacts.DEFAULT_ROOT

  /**
    * Type of artifact storage to use. Valid values are:
    * - "file": use the specified file system location for storing artifacts.
    * - "db": use the database for storing artifacts.
    *
    */
  @BeanProperty
  var `type`: String = "file"
}

object Artifacts {
  val DEFAULT_ROOT = "artifacts"
}
