package ai.digital.configuration.central.deploy

import ai.digital.doc.properties.DocPropertiesFile
import com.fasterxml.jackson.annotation.JsonProperty
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import java.beans.BeanProperty

/**
 * Enable and configure application level caching.
 * The caching is based on the standard JCache API(JSR 107).
 */

@Configuration
@ConfigurationProperties(prefix = "deploy.caches")
@DocPropertiesFile("deploy-caches.yaml")
class CachesProperties {

  /**
   * Toggle the overall caching at the application level
   */
  @BeanProperty
  var enabled: Boolean = false

  /**
   * Cache provider configuration
   */
  @BeanProperty
  @JsonProperty("provider-configuration")
  var providerConfiguration: ProviderConfiguration = new ProviderConfiguration

  /**
   * License cache configuration
   */
  @BeanProperty
  @JsonProperty("license-cache-configuration")
  var licenseCacheConfiguration: CacheConfiguration = new CacheConfiguration

}

class ProviderConfiguration {

  /**
   * Should be set to true when Deploy is a single instance setup(single master with in-process worker).
   * An embedded Caffeine cache provider is used in this case. In all other setups a standalone
   * cache server should be used and configured through the provider-configuration-file.
   */
  @BeanProperty
  var embedded: Boolean = false

  /**
   * Set the provider className to be passed to the Caching.getCachingProvider method.
   */
  @BeanProperty
  var provider: String = _

  /**
   * The provider specific configuration file name. This file should be on the classpath of all the
   * Deploy services(Master, Worker, Permission Service)
   */
  @BeanProperty
  @JsonProperty("provider-configuration-file")
  var providerConfigurationFile: String = _
}

class CacheConfiguration {
  /**
   * Toggle the individual cache
   */
  @BeanProperty
  var enabled: Boolean = true

  /**
   * Enable or disable management. If enabled the CacheMXBean for cache is registered
   * in the platform MBean server
   */
  @BeanProperty
  @JsonProperty("management-enabled")
  var managementEnabled: Boolean = true

  /**
   * Enable or disable statistics gathering for the cache
   */
  @BeanProperty
  @JsonProperty("statistics-enabled")
  var statisticsEnabled: Boolean = true

  /**
   * Time-to-live setting in minutes for entries in this cache
   */
  @BeanProperty
  @JsonProperty("ttl-minutes")
  var ttlMinutes: Int = 10
}
