package ai.digital.configuration.central.deploy.permission

import ai.digital.configuration.central.deploy.db.DatabaseProperties
import ai.digital.doc.properties.DocPropertiesFile
import com.fasterxml.jackson.annotation.JsonProperty

import scala.beans.BeanProperty

/**
  * This configuration section contains the configuration related to the embedded permission service database properties,
  * toggling the permission service and upgrade enforcer flag.
  *
  */
@DocPropertiesFile("deploy-permission-service.yaml")
class PermissionServiceProperties {
  /**
    * Permission service database configuration using hikari pool.
    * This configuration should be set if embedded Permission Service is used. In case standalone service is run this
    * properties will be ignored, and those defined for standalone service will be used by the Permission service application.
    *
    */
  @BeanProperty
  var database: DatabaseProperties = new DatabaseProperties

  /**
    * Permission service toggle switch for turning permission service calls off completely (both embedded or standalone).
    * If this value is set to false a VOID implementation of permission service will be used.
    * Default value is [xl.permission-service.enabled = true].
    *
    */
  @BeanProperty
  var enabled = true

  /**
    * Force permission service data migration. If this value is set to true, permission service upgrade will be run
    * by default and all data from permission service will be migrated from Deploy schema to corresponding
    * Permission Service schema defined in configurations or in Standalone Permission Service application schema.
    * Default value is [xl.permission-service.force-clean-upgrade = false].
    *
    */
  @BeanProperty
  @JsonProperty("force-clean-upgrade")
  var forceCleanUpgrade = false
}
