package ai.digital.configuration.central.deploy.db

import ai.digital.doc.properties.DocPropertiesFile
import com.fasterxml.jackson.annotation.JsonIgnoreProperties
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import java.beans.BeanProperty

/**
  * Main repository configuration.
  * It can be used as a single repository for the entire application too.
  * Right now you can configure to keep reporting in a separate schema or even separate database.
  */
@Configuration
@ConfigurationProperties(prefix = "xl.repository")
@JsonIgnoreProperties(ignoreUnknown = true)
@DocPropertiesFile("deploy-repository.yaml")
class MainDatabase extends DatabaseAware {

  /**
    * Configures the behaviour of artifacts.
    *
    * Where to store it and permission limitations.
    */
  @BeanProperty
  var artifacts: Artifacts = new Artifacts()

  /**
    * Database configuration through the hikari.
    */
  @BeanProperty
  var database: DatabaseProperties = new DatabaseProperties()
}
