package ai.digital.configuration.central.deploy.converter

import com.typesafe.config.ConfigFactory
import org.springframework.boot.context.properties.ConfigurationPropertiesBinding
import org.springframework.core.convert.converter.Converter
import org.springframework.stereotype.Component

import java.util.concurrent.TimeUnit
import scala.concurrent.duration.{Duration, FiniteDuration}

object HoconDurationConverter {
  def convert(value: String, unit: TimeUnit): Long = ConfigFactory.parseString(s"key = $value").getDuration("key", unit)

  def convert(value: String): FiniteDuration =
    Option(value).map { value =>
      val seconds = convert(value, TimeUnit.SECONDS)
      Duration.apply(seconds, TimeUnit.SECONDS)
    }.orNull
}

@Component
@ConfigurationPropertiesBinding
class HoconDurationConverter extends Converter[String, FiniteDuration] {
  def convert(source: String): FiniteDuration = HoconDurationConverter.convert(source)
}
