package ai.digital.configuration.central.deploy

import ai.digital.doc.properties.DocPropertiesFile
import com.fasterxml.jackson.annotation.JsonProperty
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import scala.beans.BeanProperty

/**
  * Settings for WebSocket operations.
  *
  * At this moment we sent all modifications about the CIs which are done by the current user.
  * So to prevent to verbose communications and only notify GUI with consequent update of CI tree with own changes.
  * You might be needed to adjust some thread configurations in case of too heavy load.
  */
@Configuration
@ConfigurationProperties(prefix = "deploy.websockets")
@DocPropertiesFile("deploy-webscokets.yaml")
class WebSocketsProperties {

  /**
    * Setting for WebSocketPolicy inputBufferSize.
    */
  @BeanProperty
  @JsonProperty("message-broker")
  var messageBroker: MessageBroker = new MessageBroker

  /**
    * Settings for ThreadPoolExecutor's
    */
  @BeanProperty
  @JsonProperty("threadpool")
  var threadPool: ThreadPool = new ThreadPool

  /**
    * Enables WebSockets notifications.
    *
    * In case when those notifications are not required for the system, like for example you don't use UI, you have an
    * option to disable it. The operation of the system won't be affected.
    *
    * The only thing, you won't have auto-updates of CIs made by the same user.
    */
  @BeanProperty
  @JsonProperty("enabled")
  var enabled: Boolean = true
}


class MessageBroker {
  /**
    * The size of the input (read from network layer) buffer size.
    */
  @BeanProperty
  @JsonProperty("input-buffer-size")
  var inputBufferSize: Int = 32768

}


class ThreadPool {
  /**
    * ThreadPoolExecutor's core pool size.
    */
  @BeanProperty
  @JsonProperty("core-pool-size")
  var corePoolSize: Int = 10

  /**
    * This is to enable to create daemon threads.
    */
  @BeanProperty
  @JsonProperty("daemon")
  var daemon: Boolean = false

  /**
    * ThreadPoolExecutor's keep-alive seconds.
    */
  @BeanProperty
  @JsonProperty("keep-alive-seconds")
  var keepAliveSeconds: Int = 180

  /**
    * ThreadPoolExecutor's maximum pool size.
    */
  @BeanProperty
  @JsonProperty("max-pool-size")
  var maxPoolSize: Int = 24

  /**
    * ThreadPoolExecutor's Queue Capacity.
    */
  @BeanProperty
  @JsonProperty("queue-capacity")
  var queueCapacity: Int = 500
}

