package ai.digital.configuration.central.deploy

import ai.digital.doc.properties.DocDefaultValue
import com.fasterxml.jackson.annotation.JsonProperty
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import java.util.{HashMap => JHasMap}
import scala.beans.BeanProperty

@Configuration
@ConfigurationProperties(prefix = "xl.xldeploy.placeholders")
class ArchiveExtensionMappingsProperties {

  /**
    *
    * Configuration which stream to use for which extension.
    *
    * Functionality is built on top of "Apache Commons Compress" library.
    *
    * Zip -> ZipFileArchiveStreamer
    * Jar -> JarFileArchiveStreamer
    * Tar, tar.gz, tar.bz2 -> ArchiveStreamer
    *
    * Default value is:
    * zip -> "zip",
    * jar-> "jar",
    * tar-> "tar",
    * "tar.gz" -> "tar.gz",
    * "tar.bz2"-> "tar.bz2",
    * # JEE archives
    * ear -> "jar",
    * war -> "jar",
    * # JBoss archives
    * sar -> "jar",
    * rar -> "jar",
    * aop -> "jar",
    * har -> "jar",
    * aar -> "zip"
    */
  @BeanProperty
  @DocDefaultValue(value="", removeQuote = true)
  var archiveExtensions = new JHasMap[String, String]()

  /**
    * Encoding used for decoding filenames in the ZIP files. Possible values are UTF8 and CP347. When CP347 is used decoding of the
    * filenames will work according to the ZIP specification (obeying EFS bit).
    *
    * Default value is: UTF8
    */
  @BeanProperty
  @JsonProperty("zip-encoding")
  var zipEncoding: String = "UTF8"

  /**
    * Encoding used for decoding filenames in the JAR files. Possible values are UTF8 and CP347. When CP347 is used decoding of the
    * filenames will work according to the ZIP specification (obeying EFS bit).
    *
    * Default value is: UTF8
    */
  @BeanProperty
  @JsonProperty("jar-encoding")
  var jarEncoding: String = "UTF8"
}
