package ai.digital.configuration.central.deploy

import ai.digital.doc.properties.DocPropertiesFile
import com.fasterxml.jackson.annotation.JsonInclude.Include
import com.fasterxml.jackson.annotation.{JsonInclude, JsonProperty}
import org.springframework.boot.context.properties.ConfigurationProperties
import org.springframework.context.annotation.Configuration

import java.beans.BeanProperty

/**
  * Using the Deploy satellite module, you can execute deployments on remote data centers. It includes:
  *
  * An efficient system for transferring files.
  * Executing deployment tasks transparently on satellite servers.
  * Light process execution on data centers.
  * Secure communication between Deploy and satellite servers based on Transport Layer Security (TLS).
  */
@Configuration
@ConfigurationProperties(prefix = "deploy.satellite")
@JsonInclude(Include.NON_NULL)
@DocPropertiesFile("deploy-satellite.yaml")
class SatelliteProperties {

  /**
    * Toggling the feature.
    *
    * Default: "no"
    */
  @BeanProperty
  @JsonProperty("enabled")
  var enabled: String = "no"

  @BeanProperty
  @JsonProperty("streaming")
  var streaming: SatelliteStreaming = _

  @BeanProperty
  @JsonProperty("timeout")
  var timeout: SatelliteTimeout = _
}

class SatelliteStreaming {

  /**
    * Maximum concurrent streaming uploads.
    *
    * Default: 10
    */
  @BeanProperty
  @JsonProperty("max-uploads")
  var maxConcurrentUploads: Int = 10

  /**
    * How many times to retry to upload the same artifact.
    *
    * Default: 3
    */
  @BeanProperty
  @JsonProperty("upload-attempts")
  var uploadAttempts: Int = 3
}

class SatelliteTimeout {

  /**
    * Not used.
    * Will be removed in the next version.
    *
    * Default: 10 seconds
    */
  @BeanProperty
  @JsonProperty("info")
  var info: String = "10 seconds"

  /**
    * Timeout for pinging satellite.
    *
    * If after this time the reply won't be received from satellite, it will be considered not accessible.
    *
    * Default: 5 seconds
    */
  @BeanProperty
  @JsonProperty("ping")
  var ping: String = "5 seconds"

  /**
    * Streaming connection timeout.
    *
    * Default: 10 seconds
    */
  @BeanProperty
  @JsonProperty("streaming")
  var streaming: String = "10 seconds"

  /**
    * Satellite status timeout.
    *
    * Default: 60 seconds
    */
  @BeanProperty
  @JsonProperty("remoteAsk")
  var remoteAsk: String = "60 seconds"


  @BeanProperty
  @JsonProperty("upload")
  var upload: SatelliteUpload = _
}

class SatelliteUpload {

  /**
    * Timeout on uploading artifacts
    *
    * Default: 30 seconds
    */
  @BeanProperty
  @JsonProperty("idle")
  var idle: String = "30 seconds"
}
