package ai.digital.config.server

import ai.digital.config.{ConfigServerProfiles, ServerConfigurationHelper}
import grizzled.slf4j.Logging
import javax.annotation.PostConstruct
import org.springframework.boot.autoconfigure.SpringBootApplication
import org.springframework.boot.{Banner, SpringApplication}
import org.springframework.cloud.config.server.EnableConfigServer
import org.springframework.context.annotation.Configuration

object ConfigServerApplication extends StandaloneConfigServerSystemValues {

  def main(args: Array[String]): Unit = {

    applyConfigServerSystemValues()
    val config = ServerConfigurationHelper.init()
    applyConfigServerSystemValues(config)

    val app = new SpringApplication(classOf[ConfigServerApplication])
    app.setAdditionalProfiles(ConfigServerProfiles.CONFIG_SERVER)
    app.setBannerMode(Banner.Mode.OFF)
    app.run(args: _*)
  }
}

@Configuration
@EnableConfigServer
@SpringBootApplication
class ConfigServerApplication extends Logging {

  @PostConstruct
  def startClient(): Unit = {
    logger.info("Starting standalone central configuration server")
  }
}
