package ai.digital.config.server.embedded

import ai.digital.config.{ConfigServerProfiles, RetryConfigClientSystemValues}

trait EmbeddedConfigServerSystemValues extends RetryConfigClientSystemValues {

  // enables org.springframework.cloud.context.refresh.LegacyContextRefresher
  // it needs to be set as system property, bootstrap.yaml is too late
  def applyConfigEmbeddedServerSystemValues(profiles: String): this.type = {
    if (profiles.contains(ConfigServerProfiles.CONFIG_SERVER)) {
      System.setProperty("spring.cloud.bootstrap.enabled", "true")
      System.setProperty("spring.cloud.config.enabled", "false")
    }
    this
  }
}
