package ai.digital.config.server.api

import ai.digital.config.{ConfigFileMapping, ConfigFileFilter}

trait ConfigurationPropertiesService {

  def propertiesStore(configFileFilter: ConfigFileFilter,
                      header: String,
                      properties: Iterable[(String, PropertyValue)],
                      configFileMapping: ConfigFileMapping): Iterable[String]

  def propertiesUpdate(configFileFilter: ConfigFileFilter,
                       properties: Map[String, PropertyValue],
                       configFileMapping: ConfigFileMapping): Iterable[String]

  def propertiesDelete(configFileFilter: ConfigFileFilter,
                       propertyKeys: Set[String],
                       configFileMapping: ConfigFileMapping): Iterable[String]
}
