package ai.digital.config.server

import java.lang.{Iterable => JIterable}
import java.util.{Collections, Map => JMap, Set => JSet}
import scala.beans.BeanProperty

package object api {

  case class Property(@BeanProperty var key: String, @BeanProperty var value: PropertyValue) {
    def this() = this(null, null)
  }

  object PropertyValue {
    val empty: PropertyValue = new PropertyValue()

    def apply(value: AnyRef): PropertyValue = PropertyValue(value, null, false)
  }

  case class PropertyValue(@BeanProperty var value: AnyRef,
                           @BeanProperty var comment: String,
                           @BeanProperty var commentedValue: Boolean) {
    def this() = this(null, null, false)
  }

  case class PropertiesStoreRequestBody(@BeanProperty var header: String,
                                        @BeanProperty var properties: java.lang.Iterable[Property],
                                        @BeanProperty var configFileToPropertyKeysMapping: JMap[String, JSet[String]],
                                        @BeanProperty var defaultConfigFile: String) {
    def this() = this(null, null, null, null)
  }

  case class PropertiesUpdateRequestBody(@BeanProperty var properties: JMap[String, PropertyValue],
                                         @BeanProperty var configFileToPropertyKeysMapping: JMap[String, JSet[String]],
                                         @BeanProperty var defaultConfigFile: String) {
    def this() = this(null, null, null)
  }

  case class PropertiesDeleteRequestBody(@BeanProperty var keys: JSet[String],
                                         @BeanProperty var configFileToPropertyKeysMapping: JMap[String, JSet[String]],
                                         @BeanProperty var defaultConfigFile: String) {
    def this() = this(null, null, null)
  }

  case class PropertiesStoreResponse(@BeanProperty var updatedKeys: JIterable[String]) {
    def this() = this(Collections.emptySet())
  }

  case class PropertiesUpdateResponse(@BeanProperty var updatedKeys: JIterable[String]) {
    def this() = this(Collections.emptySet())
  }

  case class PropertiesDeleteResponse(@BeanProperty var deletedKeys: JIterable[String]) {
    def this() = this(Collections.emptySet())
  }
}
