package ai.digital.config.server

import java.io.{BufferedWriter, FileWriter}
import java.util
import java.util.Properties
import ai.digital.config.server.api.PropertyValue
import org.apache.commons.lang.StringEscapeUtils
import org.springframework.core.io.Resource

trait PropertiesManagement {

  protected def replaceProperties(resource: Resource, header: String, properties: Iterable[(String, PropertyValue)]): Unit = {
    val bufferedWriter = new BufferedWriter(new FileWriter(resource.getFile))
    try {
      bufferedWriter
        .append("# ").append(header)
      bufferedWriter.newLine()
      bufferedWriter.newLine()
      properties.foreach { case (key, value) =>
        Option(value.comment)
          .filter(_.nonEmpty)
          .foreach { comment =>
            bufferedWriter.append("# ").append(comment)
            bufferedWriter.newLine();
          }
        bufferedWriter.append(if (value.commentedValue) "#" else "")
          .append(key).append('=')
          .append(if (value.value != null) StringEscapeUtils.escapeJava(value.value.toString) else "null")
        bufferedWriter.newLine();
      }
    } finally {
      bufferedWriter.close()
    }
  }

  protected def readProperties(propertiesResource: Resource): util.Map[String, AnyRef] = {
    val fileInputStream = propertiesResource.getInputStream
    try {
      val properties = new Properties()
      properties.load(fileInputStream)
      properties.asInstanceOf[util.Map[String, AnyRef]]
    } finally {
      fileInputStream.close()
    }
  }

  protected def writeProperties(propertiesResource: Resource, payloadProperties: util.Map[String, AnyRef]): Unit = {
    val writer = new FileWriter(propertiesResource.getFile)
    try {
      val properties = new Properties()
      properties.putAll(payloadProperties)
      properties.store(writer, "")
    } finally {
      writer.close()
    }
  }
}
