package ai.digital.config.server

import org.springframework.core.io.Resource
import org.yaml.snakeyaml.{DumperOptions, Yaml}

import java.nio.charset.StandardCharsets
import java.nio.file.{Files, Paths}
import java.util

trait YamlManagement {

  protected def readYaml(yamlResource: Resource)(implicit yamlParser: Yaml): util.Map[String, AnyRef] = {
    val fileInputStream = yamlResource.getInputStream
    try {
      yamlParser.load(fileInputStream).asInstanceOf[util.Map[String, AnyRef]]
    } finally {
      fileInputStream.close()
    }
  }

  protected def writeYaml(yamlResource: Resource, payloadProperties: util.Map[String, AnyRef])(implicit yamlParser: Yaml): Unit  = {
      val newContent = yamlParser.dump(payloadProperties)
      Files.write(Paths.get(yamlResource.getFile.toURI), newContent.getBytes(StandardCharsets.UTF_8))
  }

  protected def createYamlParser(): Yaml = {
    val options = new DumperOptions()
    options.setPrettyFlow(true)
    options.setDefaultFlowStyle(DumperOptions.FlowStyle.BLOCK)
    new Yaml(options)
  }
}
