package ai.digital.config.server.encryptor

import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.security.crypto.encrypt.TextEncryptor

@Configuration
class CentralConfigEncryptorConfiguration {

  @Bean
  @ConditionalOnMissingBean(Array(classOf[CentralConfigTextEncryptor]))
  def centralConfigTextEncryptor(defaultTextEncryptor: TextEncryptor): CentralConfigTextEncryptor =
    new CentralConfigTextEncryptor(defaultTextEncryptor)

}
