package ai.digital.config.server.encryptor

import ai.digital.config.ConfigFileFilter
import ai.digital.config.server.api.ConfigurationPropertiesService
import ai.digital.config.server.client.LocalConfigurationReader
import org.springframework.beans.factory.annotation.Qualifier
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean
import org.springframework.context.annotation.{Bean, Configuration}
import org.springframework.security.crypto.encrypt.TextEncryptor

@Configuration
class CentralConfigEncryptorConfiguration {

  @Bean
  @ConditionalOnMissingBean(Array(classOf[CentralConfigTextEncryptor]))
  def centralConfigTextEncryptor(defaultTextEncryptor: TextEncryptor): CentralConfigTextEncryptor =
    new CentralConfigTextEncryptor(defaultTextEncryptor)

  @Bean
  @ConditionalOnMissingBean(Array(classOf[CentralConfigEncryptor]))
  def centralConfigEncryptor(configurationReader: LocalConfigurationReader,
                             textEncryptor: CentralConfigTextEncryptor,
                             @Qualifier("defaultConfigurationPropertiesService")
                             configurationPropertiesService: ConfigurationPropertiesService,
                             configFileFilter: ConfigFileFilter): CentralConfigEncryptor =
    new CentralConfigEncryptor(configurationReader, textEncryptor, configurationPropertiesService, configFileFilter)
}
