package ai.digital.config.server.encryptor

import org.springframework.security.crypto.encrypt.TextEncryptor

class CentralConfigTextEncryptor(val defaultTextEncryptor: TextEncryptor) {

  private val PREFIX = "{cipher}"

  def encrypt(text: String): String = s"${PREFIX}${defaultTextEncryptor.encrypt(text)}"

  def ensureEncrypt(text: String): String = {
    if (isEncrypted(text))
      text
    else
      encrypt(text)
  }

  def isEncrypted(text: String): Boolean =
    Option(text)
      .exists(_.startsWith(PREFIX))
}
