package ai.digital

import java.util.{Set => JSet}
import scala.jdk.CollectionConverters._

package object config {

  object ConfigFileFilter {
    def apply(application: String, profiles: Seq[String], label: Option[String]): ConfigFileFilter =
      ConfigFileFilter(application, profiles.mkString(","), label.orNull)
  }

  case class ConfigFileFilter(application: String, profile: String, label: String = null)

  object ConfigFileMapping {
    def apply(): ConfigFileMapping = ConfigFileMapping(Map.empty, None)
    def apply(defaultConfigFile: String): ConfigFileMapping = ConfigFileMapping(Map.empty, Some(defaultConfigFile))
  }

  case class ConfigFileMapping(configFileToPropertyKeysMapping: Map[String, JSet[String]] = Map.empty, defaultConfigFile: Option[String] = None) {

    lazy val propertyKeyToConfigFileMapping: Map[String, String] =
      configFileToPropertyKeysMapping
        .flatMap { case (fileName, propertyPrefix) =>
          propertyPrefix.asScala.map(_ -> fileName)
        }

    lazy val isDefined = configFileToPropertyKeysMapping.nonEmpty || defaultConfigFile.isDefined
  }

  trait PropertyKeyFilter {
    def shouldBeEncrypted(key: String): Boolean
  }

  class ContainsPropertyKeyFilter(keyPartFilter: String) extends PropertyKeyFilter {
    override def shouldBeEncrypted(key: String): Boolean = key.contains(keyPartFilter)
  }

  class EqualPropertyKeyFilter(keyFilter: String) extends PropertyKeyFilter {
    override def shouldBeEncrypted(key: String): Boolean = key == keyFilter
  }
}
