package ai.digital.config

import com.xebialabs.deployit.util.PasswordUtil.APPLICATION_PASSWORDS
import com.xebialabs.deployit.{ServerConfigFile, ServerConfiguration}
import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter, PropertyUtil}

import java.io.File

import scala.jdk.CollectionConverters.CollectionHasAsScala

object ServerConfigurationHelper {

  val DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf")

  def init(): ServerConfiguration = {
    val passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey(null)
    PasswordEncrypter.init(passwordEncryptionKey)
    val config = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE).loadConfig(false, false, true)
    encryptPasswords()
    ServerConfiguration.setInstance(config)
    config
  }

  private def encryptPasswords(): Unit = {
    val properties = PropertyUtil.readPropertiesFile(DEFAULT_CONFIGURATION_FILE)
    properties.stringPropertyNames.asScala.foreach(key => {
      if (APPLICATION_PASSWORDS.contains(key)) {
        properties.setProperty(key,
          Option(properties.getProperty(key)).map(PasswordEncrypter.getInstance().ensureEncrypted).get)
      }
    })
    PropertyUtil.storePropertiesFile(DEFAULT_CONFIGURATION_FILE, properties)
  }

  val ConfigAdminUser: String = "_xl-deploy-config-admin_"

  val ConfigRole: String = "CONFIG_ADMIN"

  def getAdminPassword: Option[String] =
    Option(ServerConfiguration.getInstance().getAdminPassword)
      .map(PasswordEncrypter.getInstance().ensureDecrypted)
}
