package ai.digital.config

import com.xebialabs.deployit.{ServerConfigFile, ServerConfiguration}
import com.xebialabs.deployit.util.{DeployitKeys, PasswordEncrypter}

import java.io.File

object ServerConfigurationHelper {

  val DEFAULT_CONFIGURATION_FILE = new File("conf", "deployit.conf")

  def init(): ServerConfiguration = {
    val passwordEncryptionKey = DeployitKeys.getPasswordEncryptionKey(null)
    PasswordEncrypter.init(passwordEncryptionKey)
    val config = new ServerConfigFile(DEFAULT_CONFIGURATION_FILE).loadConfig(false, false, true)
    ServerConfiguration.setInstance(config)
    config
  }

  val ConfigAdminUser: String = "_xl-deploy-config-admin_"

  val ConfigRole: String = "CONFIG_ADMIN"

  def getAdminPassword: Option[String] =
    Option(ServerConfiguration.getInstance().getAdminPassword)
      .map(PasswordEncrypter.getInstance().ensureDecrypted)
}
