package ai.digital.config.server.client

import org.springframework.cloud.bootstrap.config.BootstrapPropertySource
import org.springframework.core.env.{ConfigurableEnvironment, PropertySource}
import org.springframework.stereotype.Component

import java.util.{Map => JMap}
import scala.jdk.CollectionConverters._

@Component
class LocalConfigurationReader(val environment : ConfigurableEnvironment) {

  def readPropertySource(filename: String): Map[String, AnyRef] =
    environment.getPropertySources.asScala
      .filter(source => source.getName.endsWith(filename))
      .foldRight(Map[String, AnyRef]()){
        case (source, prev) =>
          prev ++ toProperties(source)
      }

  def findPropertySources(): Iterable[(PropertySource[_], Map[String, AnyRef])] =
    environment.getPropertySources.asScala
      .filter(_.isInstanceOf[BootstrapPropertySource[_]])
      .map(source => (source, toProperties(source)))

  private def toProperties(source: PropertySource[_]): Map[String, AnyRef] =
    source.getSource.asInstanceOf[JMap[String, AnyRef]]
      .asScala
      .view.mapValues(_.toString)
      .toMap[String, AnyRef]
}
