package ai.digital.config.server.client

import com.fasterxml.jackson.databind.ObjectMapper
import grizzled.slf4j.Logging
import org.apache.http.client.methods.HttpPost
import org.springframework.retry.annotation.Retryable
import org.springframework.stereotype.Component

import java.util.{List => JList}
import scala.jdk.CollectionConverters._

@Component
class RemoteConfigurationRefresh(val httpClient: HttpClientHelper, val objectMapper: ObjectMapper) extends ConfigurationRefresh with Logging {

  @Retryable(interceptor = "configServerRetryInterceptor")
  override def refreshCentralConfiguration(): Set[String] =
    httpClient.withClient { client =>
      val httpPost = new HttpPost(httpClient.buildUri(HttpClientHelper.actuatorRefreshPath, "/centralConfiguration"))
      val response = httpClient.execute(client, httpPost)
      val confPropertyKeys = objectMapper.readerForListOf(classOf[String])
        .readValue(response)
        .asInstanceOf[JList[String]]
        .asScala
        .toSet
      logger.info(s"Refreshed property keys $confPropertyKeys")
      confPropertyKeys
    }
}
