package ai.digital.config.server.client

import java.util.{List => JList}

import grizzled.slf4j.Logging
import org.springframework.http.{HttpMethod, MediaType}
import org.springframework.retry.annotation.Retryable
import org.springframework.stereotype.Component

import scala.jdk.CollectionConverters._

@Component
class RemoteConfigurationRefresh(val restTemplateHelper: RestTemplateHelper) extends ConfigurationRefresh with Logging {

  @Retryable(interceptor = "configServerRetryInterceptor")
  override def refreshCentralConfiguration(): Set[String] = {
    val response: Option[JList[String]] = restTemplateHelper.execute(
      RestTemplateHelper.actuatorRefreshPath,
      HttpMethod.POST,
      classOf[JList[String]],
      replacePath = "/centralConfiguration",
      mediaTypeMaybe = Some(MediaType.APPLICATION_JSON_VALUE))
    val confPropertyKeys = response
      .map(_.asScala.toSet)
      .getOrElse(Set.empty)
    logger.info(s"Refreshed property keys $confPropertyKeys")
    confPropertyKeys
  }
}
