/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.config.server.config;

import io.micrometer.observation.ObservationRegistry;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.cloud.config.server.config.ConfigServerProperties;
import org.springframework.cloud.config.server.environment.CompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.EnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathCompositeEnvironmentRepository;
import org.springframework.cloud.config.server.environment.SearchPathLocator;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Primary;

@Configuration(proxyBeanMethods=false)
@ConditionalOnMissingBean(value={CompositeEnvironmentRepository.class})
public class CompositeConfiguration {
    @Bean
    @Primary
    @ConditionalOnBean(value={SearchPathLocator.class})
    public SearchPathCompositeEnvironmentRepository searchPathCompositeEnvironmentRepository(@Autowired(required=false) List<EnvironmentRepository> environmentRepos, ConfigServerProperties properties, ObjectProvider<ObservationRegistry> observationRegistry) {
        environmentRepos = environmentRepos != null ? environmentRepos : new ArrayList<EnvironmentRepository>();
        return new SearchPathCompositeEnvironmentRepository(environmentRepos, (ObservationRegistry)observationRegistry.getIfAvailable(() -> ObservationRegistry.NOOP), properties.isFailOnCompositeError());
    }

    @Bean
    @Primary
    @ConditionalOnMissingBean(value={SearchPathLocator.class})
    public CompositeEnvironmentRepository compositeEnvironmentRepository(@Autowired(required=false) List<EnvironmentRepository> environmentRepos, ConfigServerProperties properties, ObjectProvider<ObservationRegistry> observationRegistry) {
        environmentRepos = environmentRepos != null ? environmentRepos : new ArrayList<EnvironmentRepository>();
        return new CompositeEnvironmentRepository(environmentRepos, (ObservationRegistry)observationRegistry.getIfAvailable(() -> ObservationRegistry.NOOP), properties.isFailOnCompositeError());
    }
}

