/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.hazelcast;

import com.hazelcast.core.HazelcastInstance;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.util.Assert;

public class HazelcastHealthIndicator
extends AbstractHealthIndicator {
    private final HazelcastInstance hazelcast;

    public HazelcastHealthIndicator(HazelcastInstance hazelcast) {
        super("Hazelcast health check failed");
        Assert.notNull((Object)hazelcast, (String)"'hazelcast' must not be null");
        this.hazelcast = hazelcast;
    }

    @Override
    protected void doHealthCheck(Health.Builder builder) {
        if (!this.hazelcast.getLifecycleService().isRunning()) {
            builder.down();
            return;
        }
        this.hazelcast.executeTransaction(context -> {
            String uuid = this.hazelcast.getLocalEndpoint().getUuid().toString();
            builder.up().withDetail("name", this.hazelcast.getName()).withDetail("uuid", uuid);
            return null;
        });
    }
}

