/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.angus.mail.util;

import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

class TimeoutOutputStream
extends OutputStream {
    private static final String WRITE_TIMEOUT_MESSAGE = "Write timed out";
    private static final String CANNOT_GET_TIMEOUT_TASK_RESULT_MESSAGE = "Couldn't get result of timeout task";
    private final OutputStream os;
    private final ScheduledExecutorService ses;
    private final Callable<String> timeoutTask;
    private final int timeout;
    private byte[] b1;
    private final Socket socket;
    private ScheduledFuture<String> sf = null;

    public TimeoutOutputStream(Socket socket, ScheduledExecutorService ses, int timeout) throws IOException {
        this.os = socket.getOutputStream();
        this.ses = ses;
        this.timeout = timeout;
        this.socket = socket;
        this.timeoutTask = new Callable<String>(){

            @Override
            public String call() throws Exception {
                try {
                    TimeoutOutputStream.this.os.close();
                }
                catch (Throwable t) {
                    return t.toString();
                }
                return TimeoutOutputStream.WRITE_TIMEOUT_MESSAGE;
            }
        };
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this.b1 == null) {
            this.b1 = new byte[1];
        }
        this.b1[0] = (byte)b;
        this.write(this.b1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void write(byte[] bs, int off, int len) throws IOException {
        if (off < 0 || off > bs.length || len < 0 || off + len > bs.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        try {
            block12: {
                try {
                    if (this.timeout > 0) {
                        this.sf = this.ses.schedule(this.timeoutTask, (long)this.timeout, TimeUnit.MILLISECONDS);
                    }
                }
                catch (RejectedExecutionException ex) {
                    if (this.socket.isClosed()) break block12;
                    throw new IOException("Write aborted due to timeout not enforced", ex);
                }
            }
            try {
                this.os.write(bs, off, len);
            }
            catch (IOException e) {
                if (this.sf != null && !this.sf.cancel(true)) {
                    throw new IOException(this.handleTimeoutTaskResult(this.sf), e);
                }
                throw e;
            }
        }
        finally {
            if (this.sf != null) {
                this.sf.cancel(true);
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.os.close();
        if (this.sf != null) {
            this.sf.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String handleTimeoutTaskResult(ScheduledFuture<String> sf) {
        boolean wasInterrupted = Thread.interrupted();
        String exceptionMessage = null;
        try {
            String string = (String)sf.get(this.timeout, TimeUnit.MILLISECONDS);
            return string;
        }
        catch (TimeoutException e) {
            exceptionMessage = String.format("%s %s", e, this.ses.toString());
        }
        catch (InterruptedException e) {
            wasInterrupted = true;
            exceptionMessage = e.toString();
        }
        catch (ExecutionException e) {
            exceptionMessage = e.getCause() == null ? e.toString() : e.getCause().toString();
        }
        catch (Exception e) {
            exceptionMessage = e.toString();
        }
        finally {
            if (wasInterrupted) {
                Thread.currentThread().interrupt();
            }
        }
        return String.format("%s. %s", CANNOT_GET_TIMEOUT_TASK_RESULT_MESSAGE, exceptionMessage);
    }
}

