/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.access;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.util.HashMap;
import java.util.Map;
import org.springframework.security.web.access.AuthorizationManagerWebInvocationPrivilegeEvaluator;
import org.springframework.web.util.ServletRequestPathUtils;

public final class PathPatternRequestTransformer
implements AuthorizationManagerWebInvocationPrivilegeEvaluator.HttpServletRequestTransformer {
    @Override
    public HttpServletRequest transform(HttpServletRequest request) {
        AttributesSupportingHttpServletRequest wrapped = new AttributesSupportingHttpServletRequest(request);
        ServletRequestPathUtils.parseAndCache((HttpServletRequest)wrapped);
        return wrapped;
    }

    private static final class AttributesSupportingHttpServletRequest
    extends HttpServletRequestWrapper {
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        AttributesSupportingHttpServletRequest(HttpServletRequest request) {
            super(request);
        }

        public Object getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void setAttribute(String name, Object value) {
            this.attributes.put(name, value);
        }

        public void removeAttribute(String name) {
            this.attributes.remove(name);
        }
    }
}

