/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.io.copy;

import com.typesafe.config.Config;
import com.xebialabs.deployit.io.copy.ArchiveOptions;
import com.xebialabs.deployit.io.copy.ArchiveOptions$;
import com.xebialabs.deployit.io.copy.CopyStrategies$;
import com.xebialabs.deployit.io.copy.CopyStrategy;
import com.xebialabs.deployit.plugin.overthere.CopyStrategyName;
import com.xebialabs.deployit.plugin.overthere.DefaultCopyStrategyName;
import com.xebialabs.deployit.util.StreamFactoryUtil$;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.local.LocalFile;
import com.xebialabs.xlplatform.config.ConfigurationHolder$;
import grizzled.slf4j.Logger;
import grizzled.slf4j.Logging;
import java.io.Serializable;
import org.slf4j.Marker;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.HashMap;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

public final class ArtifactCopier$
implements Logging {
    public static final ArtifactCopier$ MODULE$ = new ArtifactCopier$();
    private static final List<CopyStrategy> knownStrategies;
    private static transient Logger grizzled$slf4j$Logging$$_logger;
    private static volatile transient boolean bitmap$trans$0;

    static {
        Logging.$init$((Logging)MODULE$);
        knownStrategies = new .colon.colon((Object)CopyStrategies$.MODULE$.oneByOne(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.untar(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipUnix(), (List)new .colon.colon((Object)CopyStrategies$.MODULE$.unzipWindows(), (List)Nil$.MODULE$))));
    }

    public Logger logger() {
        return Logging.logger$((Logging)this);
    }

    public String loggerName() {
        return Logging.loggerName$((Logging)this);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void trace(Function0<Object> msg) {
        Logging.trace$((Logging)this, msg);
    }

    public void trace(Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, msg, t);
    }

    public void trace(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.trace$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$((Logging)this);
    }

    public void debug(Function0<Object> msg) {
        Logging.debug$((Logging)this, msg);
    }

    public void debug(Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, msg, t);
    }

    public void debug(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.debug$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isErrorEnabled() {
        return Logging.isErrorEnabled$((Logging)this);
    }

    public void error(Function0<Object> msg) {
        Logging.error$((Logging)this, msg);
    }

    public void error(Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, msg, t);
    }

    public void error(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.error$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isInfoEnabled() {
        return Logging.isInfoEnabled$((Logging)this);
    }

    public void info(Function0<Object> msg) {
        Logging.info$((Logging)this, msg);
    }

    public void info(Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, msg, t);
    }

    public void info(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.info$((Logging)this, (Marker)mkr, msg, t);
    }

    public boolean isWarnEnabled() {
        return Logging.isWarnEnabled$((Logging)this);
    }

    public void warn(Function0<Object> msg) {
        Logging.warn$((Logging)this, msg);
    }

    public void warn(Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, msg, t);
    }

    public void warn(Marker mkr, Function0<Object> msg, Function0<Throwable> t) {
        Logging.warn$((Logging)this, (Marker)mkr, msg, t);
    }

    private Logger grizzled$slf4j$Logging$$_logger$lzycompute() {
        ArtifactCopier$ artifactCopier$ = this;
        synchronized (artifactCopier$) {
            if (!bitmap$trans$0) {
                grizzled$slf4j$Logging$$_logger = Logging.grizzled$slf4j$Logging$$_logger$((Logging)this);
                bitmap$trans$0 = true;
            }
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public Logger grizzled$slf4j$Logging$$_logger() {
        if (!bitmap$trans$0) {
            return this.grizzled$slf4j$Logging$$_logger$lzycompute();
        }
        return grizzled$slf4j$Logging$$_logger;
    }

    public void copyWithConfig(LocalFile src, OverthereFile dest, java.util.Map<String, String> config, ArchiveOptions archiveOptions) {
        if (src.isFile()) {
            src.copyTo(dest);
            return;
        }
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy: source as folder:Determining copy strategy for " + dest.getConnection() + "...");
        Option specifiedStrategy = Option$.MODULE$.apply(dest.getConnection().getOptions().getOptional("ARTIFACTFILE_COPYSTRATEGY"));
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:specifiedStrategy for host: " + dest.getConnection().getOptions().getOptional("ARTIFACTFILE_COPYSTRATEGY"));
        ObjectRef configMap = ObjectRef.create((Object)new HashMap());
        if (config != null) {
            configMap.elem = CollectionConverters$.MODULE$.MapHasAsScala(config).asScala().toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        }
        CopyStrategy copyStrategy = (CopyStrategy)specifiedStrategy.map((Function1 & Serializable)strategyName -> MODULE$.getStrategy((CopyStrategyName)strategyName)).getOrElse((Function0 & Serializable)() -> MODULE$.detectStrategy(dest.getConnection(), (Map<String, String>)((Map)configMap$1.elem), archiveOptions, src));
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:copyStrategy applied: " + copyStrategy.name() + ", zipFormat: " + copyStrategy.zipFormat() + " for source: " + src.getName() + " to destination: " + dest.getPath());
        copyStrategy.copyZipped(src, dest, archiveOptions);
    }

    public ArchiveOptions copyWithConfig$default$4() {
        return ArchiveOptions$.MODULE$.newDefaultInstance();
    }

    private List<CopyStrategy> knownStrategies() {
        return knownStrategies;
    }

    private CopyStrategy getStrategy(CopyStrategyName strategyName) {
        CopyStrategy detected = (CopyStrategy)this.knownStrategies().find((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ArtifactCopier$.$anonfun$getStrategy$1(strategyName, x$1))).getOrElse((Function0 & Serializable)() -> {
            MODULE$.logger().debug((Function0 & Serializable)() -> "folder:deploy:Unhandled specified format " + strategyName.name() + " - using " + CopyStrategyName.OneByOne.name() + " instead");
            return CopyStrategies$.MODULE$.oneByOne();
        });
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:mapped copy strategy: " + detected.zipFormat().name() + " for strategyName: " + strategyName.name());
        return detected;
    }

    public CopyStrategy detectStrategy(OverthereConnection conn, Map<String, String> backupConfig, ArchiveOptions archiveOptions, LocalFile src) {
        boolean bl;
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:No copy strategy specified on " + conn);
        Config config = ConfigurationHolder$.MODULE$.get();
        String autodetectSetting = "deploy.task.artifact-copy-strategy.autodetect";
        if (config == null) {
            this.logger().debug((Function0 & Serializable)() -> "folder:deploy:config is null, using backupConfig for autodetect setting");
            bl = StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString((String)backupConfig.getOrElse((Object)autodetectSetting, (Function0 & Serializable)() -> "false")));
        } else {
            bl = config.hasPath(autodetectSetting) && config.getBoolean(autodetectSetting);
        }
        boolean allowDetect = bl;
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:autodetect runs with autoDetect=" + allowDetect);
        CopyStrategy workingStrategy = allowDetect ? this.autoDetectCopyStrategy(src, conn, archiveOptions) : this.getStrategy(this.getDefaultStrategy(conn, archiveOptions));
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:copyStrategy runs with copy strategy used " + workingStrategy.name() + " for the source artifact " + src);
        return workingStrategy;
    }

    public CopyStrategy autoDetectCopyStrategy(LocalFile src, OverthereConnection conn, ArchiveOptions archiveOptions) {
        CopyStrategy copyStrategy;
        block16: {
            try {
                block17: {
                    block18: {
                        String archiveType;
                        String string = archiveType = StreamFactoryUtil$.MODULE$.fetchStreamFactory().getArchiveType(src.getName());
                        switch (string == null ? 0 : string.hashCode()) {
                            case -1539977967: {
                                if ("tar.bz2".equals(string)) {
                                    break;
                                }
                                break block17;
                            }
                            case -880960548: {
                                if ("tar.gz".equals(string)) {
                                    break;
                                }
                                break block17;
                            }
                            case 104987: {
                                if (!"jar".equals(string)) break block17;
                                break block18;
                            }
                            case 114597: {
                                if ("tar".equals(string)) {
                                    break;
                                }
                                break block17;
                            }
                            case 120609: {
                                if (!"zip".equals(string)) break block17;
                                break block18;
                            }
                            default: {
                                break block17;
                            }
                        }
                        copyStrategy = CopyStrategies$.MODULE$.untar();
                        break block16;
                    }
                    OperatingSystemFamily operatingSystemFamily = conn.getHostOperatingSystem();
                    if (OperatingSystemFamily.WINDOWS.equals(operatingSystemFamily)) {
                        copyStrategy = CopyStrategies$.MODULE$.unzipWindows();
                    } else if (OperatingSystemFamily.UNIX.equals(operatingSystemFamily) ? true : OperatingSystemFamily.ZOS.equals(operatingSystemFamily)) {
                        copyStrategy = CopyStrategies$.MODULE$.unzipUnix();
                    } else {
                        this.logger().warn((Function0 & Serializable)() -> "folder:deploy:archiveType not recognized for file " + src.getName() + ". Falling back to default strategy.");
                        copyStrategy = this.getStrategy(this.getDefaultStrategy(conn, archiveOptions));
                    }
                    break block16;
                }
                copyStrategy = this.getStrategy(this.getDefaultStrategy(conn, archiveOptions));
            }
            catch (Exception ex) {
                this.logger().warn((Function0 & Serializable)() -> "Exception occurred while detecting copy strategy for file: " + src.getName() + ". Falling back to default strategy.", (Function0 & Serializable)() -> ex);
                copyStrategy = this.getStrategy(this.getDefaultStrategy(conn, archiveOptions));
            }
        }
        return copyStrategy;
    }

    public CopyStrategyName getDefaultStrategy(OverthereConnection conn, ArchiveOptions archiveOptions) {
        CopyStrategyName copyStrategyName;
        DefaultCopyStrategyName defaultCopyStrategyName = archiveOptions.defaultCopyStrategyName();
        DefaultCopyStrategyName defaultCopyStrategyName2 = defaultCopyStrategyName;
        if (DefaultCopyStrategyName.OneByOne.equals(defaultCopyStrategyName2)) {
            copyStrategyName = CopyStrategyName.OneByOne;
        } else if (DefaultCopyStrategyName.Tar.equals(defaultCopyStrategyName2)) {
            copyStrategyName = CopyStrategyName.Tar;
        } else if (DefaultCopyStrategyName.Zip.equals(defaultCopyStrategyName2)) {
            OperatingSystemFamily operatingSystemFamily = conn.getHostOperatingSystem();
            if (OperatingSystemFamily.WINDOWS.equals(operatingSystemFamily)) {
                copyStrategyName = CopyStrategyName.ZipWindows;
            } else if (OperatingSystemFamily.UNIX.equals(operatingSystemFamily) ? true : OperatingSystemFamily.ZOS.equals(operatingSystemFamily)) {
                copyStrategyName = CopyStrategyName.ZipUnix;
            } else {
                this.logger().warn((Function0 & Serializable)() -> "folder:defaultCopyStrategy:os not defined for conn " + conn.getHostOperatingSystem());
                copyStrategyName = CopyStrategyName.OneByOne;
            }
        } else {
            this.logger().warn((Function0 & Serializable)() -> "folder:defaultCopyStrategy is null:fallback to OneByOne for " + defaultCopyStrategyName);
            copyStrategyName = CopyStrategyName.OneByOne;
        }
        CopyStrategyName defaultCopyStrategySelected = copyStrategyName;
        this.logger().debug((Function0 & Serializable)() -> "folder:deploy:defaultCopyStrategy:defaultCopyStrategyName is " + defaultCopyStrategyName);
        return defaultCopyStrategySelected;
    }

    public static final /* synthetic */ boolean $anonfun$getStrategy$1(CopyStrategyName strategyName$1, CopyStrategy x$1) {
        return x$1.zipFormat().equals((Object)strategyName$1);
    }

    private ArtifactCopier$() {
    }
}

