/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.security.web.webauthn.management;

import com.webauthn4j.WebAuthnManager;
import com.webauthn4j.authenticator.Authenticator;
import com.webauthn4j.authenticator.AuthenticatorImpl;
import com.webauthn4j.converter.util.CborConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.AuthenticationData;
import com.webauthn4j.data.AuthenticationParameters;
import com.webauthn4j.data.AuthenticationRequest;
import com.webauthn4j.data.RegistrationData;
import com.webauthn4j.data.RegistrationParameters;
import com.webauthn4j.data.RegistrationRequest;
import com.webauthn4j.data.attestation.AttestationObject;
import com.webauthn4j.data.attestation.authenticator.AttestedCredentialData;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.attestation.authenticator.COSEKey;
import com.webauthn4j.data.attestation.statement.COSEAlgorithmIdentifier;
import com.webauthn4j.data.client.Origin;
import com.webauthn4j.data.client.challenge.Challenge;
import com.webauthn4j.data.client.challenge.DefaultChallenge;
import com.webauthn4j.server.ServerProperty;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.springframework.security.authentication.AuthenticationTrustResolver;
import org.springframework.security.authentication.AuthenticationTrustResolverImpl;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.webauthn.api.AttestationConveyancePreference;
import org.springframework.security.web.webauthn.api.AuthenticatorAssertionResponse;
import org.springframework.security.web.webauthn.api.AuthenticatorAttestationResponse;
import org.springframework.security.web.webauthn.api.AuthenticatorSelectionCriteria;
import org.springframework.security.web.webauthn.api.AuthenticatorTransport;
import org.springframework.security.web.webauthn.api.Bytes;
import org.springframework.security.web.webauthn.api.CredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientInput;
import org.springframework.security.web.webauthn.api.ImmutableAuthenticationExtensionsClientInputs;
import org.springframework.security.web.webauthn.api.ImmutableCredentialRecord;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCose;
import org.springframework.security.web.webauthn.api.ImmutablePublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredential;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialCreationOptions;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialDescriptor;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialParameters;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRequestOptions;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialRpEntity;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialType;
import org.springframework.security.web.webauthn.api.PublicKeyCredentialUserEntity;
import org.springframework.security.web.webauthn.api.ResidentKeyRequirement;
import org.springframework.security.web.webauthn.api.UserVerificationRequirement;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialCreationOptionsRequest;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialRequestOptionsRequest;
import org.springframework.security.web.webauthn.management.PublicKeyCredentialUserEntityRepository;
import org.springframework.security.web.webauthn.management.RelyingPartyAuthenticationRequest;
import org.springframework.security.web.webauthn.management.RelyingPartyPublicKey;
import org.springframework.security.web.webauthn.management.RelyingPartyRegistrationRequest;
import org.springframework.security.web.webauthn.management.UserCredentialRepository;
import org.springframework.security.web.webauthn.management.WebAuthnRelyingPartyOperations;
import org.springframework.util.Assert;

public class Webauthn4JRelyingPartyOperations
implements WebAuthnRelyingPartyOperations {
    private final PublicKeyCredentialUserEntityRepository userEntities;
    private final UserCredentialRepository userCredentials;
    private final Set<String> allowedOrigins;
    private final PublicKeyCredentialRpEntity rp;
    private final ObjectConverter objectConverter = new ObjectConverter();
    private final AuthenticationTrustResolver trustResolver = new AuthenticationTrustResolverImpl();
    private WebAuthnManager webAuthnManager = WebAuthnManager.createNonStrictWebAuthnManager();
    private Consumer<PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder> customizeCreationOptions = options -> {};
    private Consumer<PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder> customizeRequestOptions = options -> {};

    public Webauthn4JRelyingPartyOperations(PublicKeyCredentialUserEntityRepository userEntities, UserCredentialRepository userCredentials, PublicKeyCredentialRpEntity rpEntity, Set<String> allowedOrigins) {
        Assert.notNull((Object)userEntities, (String)"userEntities cannot be null");
        Assert.notNull((Object)userCredentials, (String)"userCredentials cannot be null");
        Assert.notNull((Object)rpEntity, (String)"rpEntity cannot be null");
        Assert.notNull(allowedOrigins, (String)"allowedOrigins cannot be null");
        this.userEntities = userEntities;
        this.userCredentials = userCredentials;
        this.rp = rpEntity;
        this.allowedOrigins = allowedOrigins;
    }

    public void setWebAuthnManager(WebAuthnManager webAuthnManager) {
        Assert.notNull((Object)webAuthnManager, (String)"webAuthnManager cannot be null");
        this.webAuthnManager = webAuthnManager;
    }

    public void setCustomizeCreationOptions(Consumer<PublicKeyCredentialCreationOptions.PublicKeyCredentialCreationOptionsBuilder> customizeCreationOptions) {
        Assert.notNull(customizeCreationOptions, (String)"customizeCreationOptions must not be null");
        this.customizeCreationOptions = customizeCreationOptions;
    }

    public void setCustomizeRequestOptions(Consumer<PublicKeyCredentialRequestOptions.PublicKeyCredentialRequestOptionsBuilder> customizeRequestOptions) {
        Assert.notNull(customizeRequestOptions, (String)"customizeRequestOptions cannot be null");
        this.customizeRequestOptions = customizeRequestOptions;
    }

    @Override
    public PublicKeyCredentialCreationOptions createPublicKeyCredentialCreationOptions(PublicKeyCredentialCreationOptionsRequest request) {
        if (request == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        Authentication authentication = request.getAuthentication();
        if (!this.trustResolver.isAuthenticated(authentication)) {
            throw new IllegalArgumentException("Authentication must be authenticated");
        }
        AuthenticatorSelectionCriteria authenticatorSelection = AuthenticatorSelectionCriteria.builder().userVerification(UserVerificationRequirement.PREFERRED).residentKey(ResidentKeyRequirement.REQUIRED).build();
        ImmutableAuthenticationExtensionsClientInputs clientInputs = new ImmutableAuthenticationExtensionsClientInputs(ImmutableAuthenticationExtensionsClientInput.credProps);
        PublicKeyCredentialUserEntity userEntity = this.findUserEntityOrCreateAndSave(authentication.getName());
        List<CredentialRecord> credentialRecords = this.userCredentials.findByUserId(userEntity.getId());
        PublicKeyCredentialCreationOptions options = PublicKeyCredentialCreationOptions.builder().attestation(AttestationConveyancePreference.NONE).pubKeyCredParams(PublicKeyCredentialParameters.EdDSA, PublicKeyCredentialParameters.ES256, PublicKeyCredentialParameters.RS256).authenticatorSelection(authenticatorSelection).challenge(Bytes.random()).extensions(clientInputs).timeout(Duration.ofMinutes(5L)).user(userEntity).rp(this.rp).excludeCredentials(Webauthn4JRelyingPartyOperations.credentialDescriptors(credentialRecords)).customize(this.customizeCreationOptions).build();
        return options;
    }

    private static List<PublicKeyCredentialDescriptor> credentialDescriptors(List<CredentialRecord> credentialRecords) {
        ArrayList<PublicKeyCredentialDescriptor> result = new ArrayList<PublicKeyCredentialDescriptor>();
        for (CredentialRecord credentialRecord : credentialRecords) {
            Bytes id = Bytes.fromBase64(credentialRecord.getCredentialId().toBase64UrlString());
            PublicKeyCredentialDescriptor credentialDescriptor = PublicKeyCredentialDescriptor.builder().id(id).transports(credentialRecord.getTransports()).build();
            result.add(credentialDescriptor);
        }
        return result;
    }

    private PublicKeyCredentialUserEntity findUserEntityOrCreateAndSave(String username) {
        PublicKeyCredentialUserEntity foundUserEntity = this.userEntities.findByUsername(username);
        if (foundUserEntity != null) {
            return foundUserEntity;
        }
        PublicKeyCredentialUserEntity userEntity = ImmutablePublicKeyCredentialUserEntity.builder().displayName(username).id(Bytes.random()).name(username).build();
        this.userEntities.save(userEntity);
        return userEntity;
    }

    @Override
    public CredentialRecord registerCredential(RelyingPartyRegistrationRequest rpRegistrationRequest) {
        Assert.notNull((Object)rpRegistrationRequest, (String)"rpRegistrationRequest cannot be null");
        Bytes credentialId = rpRegistrationRequest.getPublicKey().getCredential().getRawId();
        CredentialRecord existingCredential = this.userCredentials.findByCredentialId(credentialId);
        if (existingCredential != null) {
            throw new IllegalArgumentException("Credential with id " + String.valueOf(credentialId) + " already exists");
        }
        PublicKeyCredentialCreationOptions creationOptions = rpRegistrationRequest.getCreationOptions();
        String rpId = creationOptions.getRp().getId();
        RelyingPartyPublicKey publicKey = rpRegistrationRequest.getPublicKey();
        PublicKeyCredential<AuthenticatorAttestationResponse> credential = publicKey.getCredential();
        AuthenticatorAttestationResponse response = credential.getResponse();
        Set<Origin> origins = this.toOrigins();
        byte[] base64Challenge = creationOptions.getChallenge().getBytes();
        byte[] attestationObject = response.getAttestationObject().getBytes();
        byte[] clientDataJSON = response.getClientDataJSON().getBytes();
        DefaultChallenge challenge = new DefaultChallenge(base64Challenge);
        byte[] tokenBindingId = null;
        ServerProperty serverProperty = new ServerProperty(origins, rpId, (Challenge)challenge, tokenBindingId);
        boolean userVerificationRequired = creationOptions.getAuthenticatorSelection().getUserVerification() == UserVerificationRequirement.REQUIRED;
        boolean userPresenceRequired = true;
        List<com.webauthn4j.data.PublicKeyCredentialParameters> pubKeyCredParams = this.convertCredentialParamsToWebauthn4j(creationOptions.getPubKeyCredParams());
        Set<String> transports = Webauthn4JRelyingPartyOperations.convertTransportsToString(response);
        RegistrationRequest webauthn4jRegistrationRequest = new RegistrationRequest(attestationObject, clientDataJSON, transports);
        RegistrationParameters registrationParameters = new RegistrationParameters(serverProperty, pubKeyCredParams, userVerificationRequired, userPresenceRequired);
        RegistrationData registrationData = this.webAuthnManager.validate(webauthn4jRegistrationRequest, registrationParameters);
        AuthenticatorData authData = registrationData.getAttestationObject().getAuthenticatorData();
        CborConverter cborConverter = this.objectConverter.getCborConverter();
        COSEKey coseKey = authData.getAttestedCredentialData().getCOSEKey();
        byte[] rawCoseKey = cborConverter.writeValueAsBytes((Object)coseKey);
        ImmutableCredentialRecord userCredential = ImmutableCredentialRecord.builder().userEntityUserId(creationOptions.getUser().getId()).credentialType(credential.getType()).credentialId(credential.getRawId()).publicKey(new ImmutablePublicKeyCose(rawCoseKey)).signatureCount(authData.getSignCount()).uvInitialized(authData.isFlagUV()).transports(Webauthn4JRelyingPartyOperations.convertTransports(registrationData.getTransports())).backupEligible(authData.isFlagBE()).backupState(authData.isFlagBS()).label(publicKey.getLabel()).attestationClientDataJSON(credential.getResponse().getClientDataJSON()).attestationObject(credential.getResponse().getAttestationObject()).build();
        this.userCredentials.save(userCredential);
        return userCredential;
    }

    private static Set<String> convertTransportsToString(AuthenticatorAttestationResponse response) {
        if (response.getTransports() == null) {
            return null;
        }
        HashSet<String> transports = new HashSet<String>(response.getTransports().size());
        for (AuthenticatorTransport transport : response.getTransports()) {
            transports.add(transport.getValue());
        }
        return transports;
    }

    private List<com.webauthn4j.data.PublicKeyCredentialParameters> convertCredentialParamsToWebauthn4j(List<PublicKeyCredentialParameters> parameters) {
        return parameters.stream().map(this::convertParamToWebauthn4j).collect(Collectors.toUnmodifiableList());
    }

    private com.webauthn4j.data.PublicKeyCredentialParameters convertParamToWebauthn4j(PublicKeyCredentialParameters parameter) {
        if (parameter.getType() != PublicKeyCredentialType.PUBLIC_KEY) {
            throw new IllegalArgumentException("Cannot convert unknown credential type " + String.valueOf(parameter.getType()) + " to webauthn4j");
        }
        long algValue = parameter.getAlg().getValue();
        COSEAlgorithmIdentifier alg = COSEAlgorithmIdentifier.create((long)algValue);
        return new com.webauthn4j.data.PublicKeyCredentialParameters(com.webauthn4j.data.PublicKeyCredentialType.PUBLIC_KEY, alg);
    }

    private Set<Origin> toOrigins() {
        return this.allowedOrigins.stream().map(Origin::new).collect(Collectors.toSet());
    }

    private static Set<AuthenticatorTransport> convertTransports(Set<com.webauthn4j.data.AuthenticatorTransport> transports) {
        if (transports == null) {
            return Collections.emptySet();
        }
        return transports.stream().map(t -> AuthenticatorTransport.valueOf(t.getValue())).collect(Collectors.toUnmodifiableSet());
    }

    @Override
    public PublicKeyCredentialRequestOptions createCredentialRequestOptions(PublicKeyCredentialRequestOptionsRequest request) {
        Authentication authentication = request.getAuthentication();
        List<CredentialRecord> credentialRecords = this.findCredentialRecords(authentication);
        return PublicKeyCredentialRequestOptions.builder().allowCredentials(Webauthn4JRelyingPartyOperations.credentialDescriptors(credentialRecords)).challenge(Bytes.random()).rpId(this.rp.getId()).timeout(Duration.ofMinutes(5L)).userVerification(UserVerificationRequirement.PREFERRED).customize(this.customizeRequestOptions).build();
    }

    private List<CredentialRecord> findCredentialRecords(Authentication authentication) {
        if (!this.trustResolver.isAuthenticated(authentication)) {
            return Collections.emptyList();
        }
        PublicKeyCredentialUserEntity userEntity = this.userEntities.findByUsername(authentication.getName());
        if (userEntity == null) {
            return Collections.emptyList();
        }
        return this.userCredentials.findByUserId(userEntity.getId());
    }

    @Override
    public PublicKeyCredentialUserEntity authenticate(RelyingPartyAuthenticationRequest request) {
        PublicKeyCredentialRequestOptions requestOptions = request.getRequestOptions();
        AuthenticatorAssertionResponse assertionResponse = request.getPublicKey().getResponse();
        Bytes keyId = request.getPublicKey().getRawId();
        CredentialRecord credentialRecord = this.userCredentials.findByCredentialId(keyId);
        CborConverter cborConverter = this.objectConverter.getCborConverter();
        AttestationObject attestationObject = (AttestationObject)cborConverter.readValue(credentialRecord.getAttestationObject().getBytes(), AttestationObject.class);
        AuthenticatorData authData = attestationObject.getAuthenticatorData();
        AttestedCredentialData data = new AttestedCredentialData(authData.getAttestedCredentialData().getAaguid(), keyId.getBytes(), authData.getAttestedCredentialData().getCOSEKey());
        AuthenticatorImpl authenticator = new AuthenticatorImpl(data, attestationObject.getAttestationStatement(), credentialRecord.getSignatureCount());
        if (authenticator == null) {
            throw new IllegalStateException("No authenticator found");
        }
        Set<Origin> origins = this.toOrigins();
        DefaultChallenge challenge = new DefaultChallenge(requestOptions.getChallenge().getBytes());
        byte[] tokenBindingId = null;
        ServerProperty serverProperty = new ServerProperty(origins, requestOptions.getRpId(), (Challenge)challenge, tokenBindingId);
        boolean userVerificationRequired = request.getRequestOptions().getUserVerification() == UserVerificationRequirement.REQUIRED;
        AuthenticationRequest authenticationRequest = new AuthenticationRequest(request.getPublicKey().getId().getBytes(), assertionResponse.getAuthenticatorData().getBytes(), assertionResponse.getClientDataJSON().getBytes(), assertionResponse.getSignature().getBytes());
        AuthenticationParameters authenticationParameters = new AuthenticationParameters(serverProperty, (Authenticator)authenticator, userVerificationRequired);
        AuthenticationData authenticationData = this.webAuthnManager.validate(authenticationRequest, authenticationParameters);
        long updatedSignCount = authenticationData.getAuthenticatorData().getSignCount();
        ImmutableCredentialRecord updatedRecord = ImmutableCredentialRecord.fromCredentialRecord(credentialRecord).lastUsed(Instant.now()).signatureCount(updatedSignCount).build();
        this.userCredentials.save(updatedRecord);
        return this.userEntities.findById(credentialRecord.getUserEntityUserId());
    }
}

