/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.overthere.winrs;

import com.xebialabs.overthere.CmdLine;
import com.xebialabs.overthere.ConnectionOptions;
import com.xebialabs.overthere.OperatingSystemFamily;
import com.xebialabs.overthere.Overthere;
import com.xebialabs.overthere.OverthereConnection;
import com.xebialabs.overthere.OverthereFile;
import com.xebialabs.overthere.OverthereProcess;
import com.xebialabs.overthere.cifs.CifsConnectionType;
import com.xebialabs.overthere.cifs.ConnectionValidator;
import com.xebialabs.overthere.spi.AddressPortMapper;
import com.xebialabs.overthere.spi.ProcessConnection;
import com.xebialabs.overthere.util.OverthereUtils;
import java.net.InetSocketAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WinrsConnection
implements ProcessConnection {
    private OperatingSystemFamily os;
    private OverthereFile workingDirectory;
    private String address;
    private int port;
    private String password;
    private String username;
    private String protocol;
    private CifsConnectionType connectionType = CifsConnectionType.WINRM_NATIVE;
    private ConnectionOptions options;
    private OverthereConnection winrsProxyConnection;
    private static final Logger logger = LoggerFactory.getLogger(WinrsConnection.class);

    public WinrsConnection(ConnectionOptions options, AddressPortMapper mapper, OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
        this.options = options;
        this.os = options.getEnum("os", OperatingSystemFamily.class);
        String unmappedAddress = (String)options.get("address");
        int unmappedPort = options.get("port", this.connectionType.getDefaultPort(options));
        InetSocketAddress addressPort = mapper.map(InetSocketAddress.createUnresolved(unmappedAddress, unmappedPort));
        this.address = addressPort.getHostName();
        this.port = addressPort.getPort();
        this.username = (String)options.get("username");
        this.password = (String)options.get(ConnectionOptions.PASSWORD);
        this.protocol = (String)options.get("protocol");
        ConnectionValidator.checkIsWindowsHost(this.os, this.protocol, this.connectionType);
        ConnectionValidator.checkNotThroughJumpstation(mapper, this.protocol, this.connectionType);
        ConnectionValidator.checkNoSingleQuoteInPassword(this.password, this.protocol, this.connectionType);
    }

    @Override
    public void connect() {
        this.connectToWinrsProxy(this.options);
        if (this.winrsProxyConnection.getHostOperatingSystem() != OperatingSystemFamily.WINDOWS) {
            this.disconnectFromWinrsProxy();
            throw new IllegalArgumentException(String.format("Cannot create a smb:%s connection with a winrs proxy that is not running Windows", this.connectionType.toString().toLowerCase()));
        }
    }

    @Override
    public OverthereProcess startProcess(CmdLine cmd) {
        OverthereUtils.checkNotNull(cmd, "Cannot execute null command line", new Object[0]);
        OverthereUtils.checkArgument(cmd.getArguments().size() > 0, "Cannot execute empty command line", new Object[0]);
        String obfuscatedCmd = cmd.toCommandLine(this.os, true);
        logger.info("Starting command [{}] on [{}]", (Object)obfuscatedCmd, (Object)this);
        CmdLine winrsCmd = new CmdLine();
        winrsCmd.addArgument("winrs");
        winrsCmd.addArgument("-remote:" + this.address + ":" + this.port);
        winrsCmd.addArgument("-username:" + this.username);
        winrsCmd.addPassword("-password:" + this.password);
        if (this.workingDirectory != null) {
            winrsCmd.addArgument("-directory:" + this.workingDirectory.getPath());
        }
        if (this.options.getBoolean("winrsNoecho", false)) {
            winrsCmd.addArgument("-noecho");
        }
        if (this.options.getBoolean("winrsNoprofile", false)) {
            winrsCmd.addArgument("-noprofile");
        }
        if (this.options.getBoolean("winrsAllowDelegate", false)) {
            winrsCmd.addArgument("-allowdelegate");
        }
        if (this.options.getBoolean("winrsCompression", false)) {
            winrsCmd.addArgument("-compression");
        }
        if (this.options.getBoolean("winrsUnencrypted", false)) {
            winrsCmd.addArgument("-unencrypted");
        }
        if (this.options.getBoolean("winrmEnableHttps", false)) {
            winrsCmd.addArgument("-usessl");
        }
        winrsCmd.add(cmd.getArguments());
        return this.winrsProxyConnection.startProcess(winrsCmd);
    }

    @Override
    public void close() {
        this.disconnectFromWinrsProxy();
    }

    @Override
    public void setWorkingDirectory(OverthereFile workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    OverthereConnection connectToWinrsProxy(ConnectionOptions options) {
        logger.debug("Connecting to winrs proxy");
        String winrsProxyProtocol = options.get("winrsProxyProtocol", "local");
        ConnectionOptions winrsProxyConnectionOptions = options.get("winrsProxyConnectionOptions", new ConnectionOptions());
        this.winrsProxyConnection = Overthere.getConnection(winrsProxyProtocol, winrsProxyConnectionOptions);
        return this.winrsProxyConnection;
    }

    void disconnectFromWinrsProxy() {
        logger.debug("Disconnecting from winrs proxy");
        OverthereUtils.closeQuietly(this.winrsProxyConnection);
    }
}

