/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.merge;

import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.attributes.Attribute;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.attributes.AttributesNodeProvider;
import org.eclipse.jgit.diff.DiffAlgorithm;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.diff.RawTextComparator;
import org.eclipse.jgit.diff.Sequence;
import org.eclipse.jgit.dircache.Checkout;
import org.eclipse.jgit.dircache.DirCache;
import org.eclipse.jgit.dircache.DirCacheBuildIterator;
import org.eclipse.jgit.dircache.DirCacheBuilder;
import org.eclipse.jgit.dircache.DirCacheCheckout;
import org.eclipse.jgit.dircache.DirCacheEntry;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.errors.IndexWriteException;
import org.eclipse.jgit.errors.NoWorkTreeException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.lib.FileMode;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.ObjectInserter;
import org.eclipse.jgit.lib.ObjectLoader;
import org.eclipse.jgit.lib.ObjectReader;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.StoredConfig;
import org.eclipse.jgit.merge.ContentMergeStrategy;
import org.eclipse.jgit.merge.MergeAlgorithm;
import org.eclipse.jgit.merge.MergeFormatter;
import org.eclipse.jgit.merge.MergeResult;
import org.eclipse.jgit.merge.ThreeWayMerger;
import org.eclipse.jgit.revwalk.RevTree;
import org.eclipse.jgit.submodule.SubmoduleConflict;
import org.eclipse.jgit.treewalk.AbstractTreeIterator;
import org.eclipse.jgit.treewalk.CanonicalTreeParser;
import org.eclipse.jgit.treewalk.NameConflictTreeWalk;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.treewalk.filter.TreeFilter;
import org.eclipse.jgit.util.LfsFactory;
import org.eclipse.jgit.util.TemporaryBuffer;
import org.eclipse.jgit.util.io.EolStreamTypeUtil;

public class ResolveMerger
extends ThreeWayMerger {
    protected NameConflictTreeWalk tw;
    protected String[] commitNames;
    protected static final int T_BASE = 0;
    protected static final int T_OURS = 1;
    protected static final int T_THEIRS = 2;
    protected static final int T_INDEX = 3;
    protected static final int T_FILE = 4;
    protected WorkTreeUpdater workTreeUpdater;
    protected ObjectId resultTree;
    protected List<String> modifiedFiles = new ArrayList<String>();
    protected List<String> unmergedPaths = new ArrayList<String>();
    protected Map<String, MergeResult<? extends Sequence>> mergeResults = new HashMap<String, MergeResult<? extends Sequence>>();
    protected Map<String, MergeFailureReason> failingPaths = new HashMap<String, MergeFailureReason>();
    protected boolean enterSubtree;
    protected boolean inCore;
    protected DirCache dircache;
    protected WorkingTreeIterator workingTreeIterator;
    protected MergeAlgorithm mergeAlgorithm;
    @NonNull
    private ContentMergeStrategy contentStrategy = ContentMergeStrategy.CONFLICT;
    protected AttributesNodeProvider attributesNodeProvider;
    private static final Attributes NO_ATTRIBUTES = new Attributes(new Attribute[0]);

    private static MergeAlgorithm getMergeAlgorithm(Config config) {
        DiffAlgorithm.SupportedAlgorithm diffAlg = config.getEnum("diff", null, "algorithm", DiffAlgorithm.SupportedAlgorithm.HISTOGRAM);
        return new MergeAlgorithm(DiffAlgorithm.getAlgorithm(diffAlg));
    }

    private static String[] defaultCommitNames() {
        return new String[]{"BASE", "OURS", "THEIRS"};
    }

    protected ResolveMerger(Repository local, boolean inCore) {
        super(local);
        StoredConfig config = local.getConfig();
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = inCore;
    }

    protected ResolveMerger(Repository local) {
        this(local, false);
    }

    protected ResolveMerger(ObjectInserter inserter, Config config) {
        super(inserter);
        this.mergeAlgorithm = ResolveMerger.getMergeAlgorithm(config);
        this.commitNames = ResolveMerger.defaultCommitNames();
        this.inCore = true;
    }

    @NonNull
    public ContentMergeStrategy getContentMergeStrategy() {
        return this.contentStrategy;
    }

    public void setContentMergeStrategy(ContentMergeStrategy strategy) {
        this.contentStrategy = strategy == null ? ContentMergeStrategy.CONFLICT : strategy;
    }

    @Override
    protected boolean mergeImpl() throws IOException {
        return this.mergeTrees(this.mergeBase(), this.sourceTrees[0], this.sourceTrees[1], false);
    }

    private DirCacheEntry add(byte[] path, CanonicalTreeParser p, int stage, Instant lastModified, long len) {
        if (p != null && !p.getEntryFileMode().equals(FileMode.TREE)) {
            return this.workTreeUpdater.addExistingToIndex(p.getEntryObjectId(), path, p.getEntryFileMode(), stage, lastModified, (int)len);
        }
        return null;
    }

    private DirCacheEntry addConflict(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
        this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
        return this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
    }

    private DirCacheEntry keep(DirCacheEntry e) {
        return this.workTreeUpdater.addExistingToIndex(e.getObjectId(), e.getRawPath(), e.getFileMode(), e.getStage(), e.getLastModifiedInstant(), e.getLength());
    }

    protected void addToCheckout(String path, DirCacheEntry entry, Attributes[] attributes) throws IOException {
        CoreConfig.EolStreamType cleanupStreamType = this.workTreeUpdater.detectCheckoutStreamType(attributes[1]);
        String cleanupSmudgeCommand = this.tw.getSmudgeCommand(attributes[1]);
        CoreConfig.EolStreamType checkoutStreamType = this.workTreeUpdater.detectCheckoutStreamType(attributes[2]);
        String checkoutSmudgeCommand = this.tw.getSmudgeCommand(attributes[2]);
        this.workTreeUpdater.addToCheckout(path, entry, cleanupStreamType, cleanupSmudgeCommand, checkoutStreamType, checkoutSmudgeCommand);
    }

    protected void addDeletion(String path, boolean isFile, Attributes attributes) throws IOException {
        if (this.db == null || this.nonNullRepo().isBare() || !isFile) {
            return;
        }
        File file = new File(this.nonNullRepo().getWorkTree(), path);
        CoreConfig.EolStreamType streamType = this.workTreeUpdater.detectCheckoutStreamType(attributes);
        String smudgeCommand = this.tw.getSmudgeCommand(attributes);
        this.workTreeUpdater.deleteFile(path, file, streamType, smudgeCommand);
    }

    protected boolean processEntry(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, DirCacheBuildIterator index, WorkingTreeIterator work, boolean ignoreConflicts, Attributes[] attributes) throws IOException {
        boolean gitLinkMerging;
        this.enterSubtree = true;
        int modeO = this.tw.getRawMode(1);
        int modeT = this.tw.getRawMode(2);
        int modeB = this.tw.getRawMode(0);
        boolean bl = gitLinkMerging = ResolveMerger.isGitLink(modeO) || ResolveMerger.isGitLink(modeT) || ResolveMerger.isGitLink(modeB);
        if (modeO == 0 && modeT == 0 && modeB == 0) {
            return true;
        }
        if (this.isIndexDirty()) {
            return false;
        }
        DirCacheEntry ourDce = null;
        if (index == null || index.getDirCacheEntry() == null) {
            if (ResolveMerger.nonTree(modeO)) {
                ourDce = new DirCacheEntry(this.tw.getRawPath());
                ourDce.setObjectId(this.tw.getObjectId(1));
                ourDce.setFileMode(this.tw.getFileMode(1));
            }
        } else {
            ourDce = index.getDirCacheEntry();
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT) && this.tw.idEqual(1, 2)) {
            if (modeO == modeT) {
                this.keep(ourDce);
                return true;
            }
            int newMode = this.mergeFileModes(modeB, modeO, modeT);
            if (newMode != FileMode.MISSING.getBits()) {
                if (newMode == modeO) {
                    this.keep(ourDce);
                } else {
                    if (this.isWorktreeDirty(work, ourDce)) {
                        return false;
                    }
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (!ignoreConflicts) {
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(this.tw.getPathString());
                this.mergeResults.put(this.tw.getPathString(), new MergeResult(Collections.emptyList()));
            }
            return true;
        }
        if (modeB == modeT && this.tw.idEqual(0, 2)) {
            if (ourDce != null) {
                this.keep(ourDce);
            }
            return true;
        }
        if (modeB == modeO && this.tw.idEqual(0, 1)) {
            if (this.isWorktreeDirty(work, ourDce)) {
                return false;
            }
            if (ResolveMerger.nonTree(modeT)) {
                DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                if (e != null) {
                    this.addToCheckout(this.tw.getPathString(), e, attributes);
                }
                return true;
            }
            if (this.tw.getTreeCount() > 4 && this.tw.getRawMode(4) == 0) {
                return true;
            }
            if (modeT != 0 && modeT == modeB) {
                return true;
            }
            this.addDeletion(this.tw.getPathString(), ResolveMerger.nonTree(modeO), attributes[1]);
            return true;
        }
        if (this.tw.isSubtree()) {
            if (ResolveMerger.nonTree(modeO) != ResolveMerger.nonTree(modeT)) {
                if (ignoreConflicts) {
                    this.enterSubtree = false;
                    return true;
                }
                if (ResolveMerger.nonTree(modeB)) {
                    this.add(this.tw.getRawPath(), base, 1, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(modeO)) {
                    this.add(this.tw.getRawPath(), ours, 2, Instant.EPOCH, 0L);
                }
                if (ResolveMerger.nonTree(modeT)) {
                    this.add(this.tw.getRawPath(), theirs, 3, Instant.EPOCH, 0L);
                }
                this.unmergedPaths.add(this.tw.getPathString());
                this.enterSubtree = false;
                return true;
            }
            if (!ResolveMerger.nonTree(modeO)) {
                return true;
            }
        }
        if (ResolveMerger.nonTree(modeO) && ResolveMerger.nonTree(modeT)) {
            boolean worktreeDirty = this.isWorktreeDirty(work, ourDce);
            if (!attributes[1].canBeContentMerged() && worktreeDirty) {
                return false;
            }
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
                return true;
            }
            if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
                return true;
            }
            if (!attributes[1].canBeContentMerged()) {
                switch (this.getContentMergeStrategy()) {
                    case OURS: {
                        this.keep(ourDce);
                        return true;
                    }
                    case THEIRS: {
                        DirCacheEntry theirEntry = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(this.tw.getPathString(), theirEntry, attributes);
                        return true;
                    }
                }
                String currentPath = this.tw.getPathString();
                MergeResult result = new MergeResult(Collections.emptyList());
                result.setContainsConflicts(true);
                this.mergeResults.put(currentPath, result);
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(currentPath);
                return true;
            }
            if (worktreeDirty) {
                return false;
            }
            MergeResult<RawText> result = null;
            boolean hasSymlink = FileMode.SYMLINK.equals(modeO) || FileMode.SYMLINK.equals(modeT);
            String currentPath = this.tw.getPathString();
            if (!hasSymlink) {
                try {
                    result = this.contentMerge(base, ours, theirs, attributes, this.getContentMergeStrategy());
                    if (result.containsConflicts() && !ignoreConflicts) {
                        result.setContainsConflicts(true);
                        this.unmergedPaths.add(currentPath);
                    } else if (ignoreConflicts) {
                        result.setContainsConflicts(false);
                    }
                    this.updateIndex(base, ours, theirs, result, attributes[1]);
                    this.workTreeUpdater.markAsModified(currentPath);
                    this.addToCheckout(currentPath, null, attributes);
                    return true;
                }
                catch (BinaryBlobException binaryBlobException) {
                    // empty catch block
                }
            }
            switch (this.getContentMergeStrategy()) {
                case OURS: {
                    this.keep(ourDce);
                    return true;
                }
                case THEIRS: {
                    DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                    if (e != null) {
                        this.addToCheckout(currentPath, e, attributes);
                    }
                    return true;
                }
            }
            result = new MergeResult(Collections.emptyList());
            result.setContainsConflicts(true);
            if (hasSymlink) {
                if (ignoreConflicts) {
                    result.setContainsConflicts(false);
                    if ((modeT & 0xF000) == 32768) {
                        DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                        this.addToCheckout(currentPath, e, attributes);
                    } else {
                        this.keep(ourDce);
                    }
                } else {
                    DirCacheEntry e = this.addConflict(base, ours, theirs);
                    this.mergeResults.put(currentPath, result);
                    this.unmergedPaths.add(currentPath);
                    if ((modeT & 0xF000) == 32768 && e != null) {
                        this.addToCheckout(currentPath, e, attributes);
                    }
                }
            } else {
                result.setContainsConflicts(true);
                this.addConflict(base, ours, theirs);
                this.unmergedPaths.add(currentPath);
                this.mergeResults.put(currentPath, result);
            }
            return true;
        }
        if (modeO != modeT && (modeO != 0 && !this.tw.idEqual(0, 1) || modeT != 0 && !this.tw.idEqual(0, 2))) {
            if (gitLinkMerging && ignoreConflicts) {
                this.add(this.tw.getRawPath(), ours, 0, Instant.EPOCH, 0L);
            } else if (gitLinkMerging) {
                this.addConflict(base, ours, theirs);
                MergeResult<SubmoduleConflict> result = ResolveMerger.createGitLinksMergeResult(base, ours, theirs);
                result.setContainsConflicts(true);
                this.mergeResults.put(this.tw.getPathString(), result);
                this.unmergedPaths.add(this.tw.getPathString());
            } else {
                MergeResult<Object> result;
                boolean isSymLink;
                boolean bl2 = isSymLink = ((modeO | modeT) & 0xF000) == 40960;
                if (isSymLink) {
                    result = new MergeResult(Collections.emptyList());
                    result.setContainsConflicts(true);
                } else {
                    try {
                        result = this.contentMerge(base, ours, theirs, attributes, ContentMergeStrategy.CONFLICT);
                    }
                    catch (BinaryBlobException e) {
                        result = new MergeResult(Collections.emptyList());
                        result.setContainsConflicts(true);
                    }
                }
                if (ignoreConflicts) {
                    result.setContainsConflicts(false);
                    if (isSymLink) {
                        if (modeO != 0) {
                            this.keep(ourDce);
                        } else {
                            if (this.isWorktreeDirty(work, ourDce)) {
                                return false;
                            }
                            DirCacheEntry e = this.add(this.tw.getRawPath(), theirs, 0, Instant.EPOCH, 0L);
                            if (e != null) {
                                this.addToCheckout(this.tw.getPathString(), e, attributes);
                            }
                        }
                    } else {
                        this.updateIndex(base, ours, theirs, result, attributes[1]);
                    }
                } else {
                    DirCacheEntry e = this.addConflict(base, ours, theirs);
                    if (modeO == 0) {
                        if (this.isWorktreeDirty(work, ourDce)) {
                            return false;
                        }
                        if (ResolveMerger.nonTree(modeT) && e != null) {
                            this.addToCheckout(this.tw.getPathString(), e, attributes);
                        }
                    }
                    this.unmergedPaths.add(this.tw.getPathString());
                    this.mergeResults.put(this.tw.getPathString(), result);
                }
            }
        }
        return true;
    }

    private static MergeResult<SubmoduleConflict> createGitLinksMergeResult(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs) {
        return new MergeResult<SubmoduleConflict>(Arrays.asList(new SubmoduleConflict(base == null ? null : base.getEntryObjectId()), new SubmoduleConflict(ours == null ? null : ours.getEntryObjectId()), new SubmoduleConflict(theirs == null ? null : theirs.getEntryObjectId())));
    }

    private MergeResult<RawText> contentMerge(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, Attributes[] attributes, ContentMergeStrategy strategy) throws BinaryBlobException, IOException {
        RawText baseText = base == null ? RawText.EMPTY_TEXT : this.getRawText(base.getEntryObjectId(), attributes[0]);
        RawText ourText = ours == null ? RawText.EMPTY_TEXT : this.getRawText(ours.getEntryObjectId(), attributes[1]);
        RawText theirsText = theirs == null ? RawText.EMPTY_TEXT : this.getRawText(theirs.getEntryObjectId(), attributes[2]);
        this.mergeAlgorithm.setContentMergeStrategy(this.getAttributesContentMergeStrategy(attributes[1], strategy));
        return this.mergeAlgorithm.merge(RawTextComparator.DEFAULT, baseText, ourText, theirsText);
    }

    private ContentMergeStrategy getAttributesContentMergeStrategy(Attributes attributes, ContentMergeStrategy strategy) {
        String attrValue;
        Attribute attr = attributes.get("merge");
        if (attr != null && (attrValue = attr.getValue()) != null && attrValue.equals("union")) {
            return ContentMergeStrategy.UNION;
        }
        return strategy;
    }

    private boolean isIndexDirty() {
        boolean isDirty;
        if (this.inCore) {
            return false;
        }
        int modeI = this.tw.getRawMode(3);
        int modeO = this.tw.getRawMode(1);
        boolean bl = isDirty = ResolveMerger.nonTree(modeI) && (modeO != modeI || !this.tw.idEqual(3, 1));
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_INDEX);
        }
        return isDirty;
    }

    private boolean isWorktreeDirty(WorkingTreeIterator work, DirCacheEntry ourDce) throws IOException {
        boolean isDirty;
        if (work == null) {
            return false;
        }
        int modeF = this.tw.getRawMode(4);
        int modeO = this.tw.getRawMode(1);
        if (ourDce != null) {
            isDirty = work.isModified(ourDce, true, this.reader);
        } else {
            isDirty = work.isModeDifferent(modeO);
            if (!isDirty && ResolveMerger.nonTree(modeF)) {
                boolean bl = isDirty = !this.tw.idEqual(4, 1);
            }
        }
        if (isDirty && modeF == 16384 && modeO == 0) {
            isDirty = false;
        }
        if (isDirty) {
            this.failingPaths.put(this.tw.getPathString(), MergeFailureReason.DIRTY_WORKTREE);
        }
        return isDirty;
    }

    private void updateIndex(CanonicalTreeParser base, CanonicalTreeParser ours, CanonicalTreeParser theirs, MergeResult<RawText> result, Attributes attributes) throws IOException {
        TemporaryBuffer rawMerged = null;
        try {
            File mergedFile;
            rawMerged = this.doMerge(result);
            File file = mergedFile = this.inCore ? null : this.writeMergedFile(rawMerged, attributes);
            if (result.containsConflicts()) {
                this.addConflict(base, ours, theirs);
                this.mergeResults.put(this.tw.getPathString(), result);
                return;
            }
            Instant lastModified = mergedFile == null ? null : this.nonNullRepo().getFS().lastModifiedInstant(mergedFile);
            int newMode = this.mergeFileModes(this.tw.getRawMode(0), this.tw.getRawMode(1), this.tw.getRawMode(2));
            FileMode mode = newMode == FileMode.MISSING.getBits() ? FileMode.REGULAR_FILE : FileMode.fromBits(newMode);
            this.workTreeUpdater.insertToIndex(rawMerged.openInputStream(), this.tw.getPathString().getBytes(StandardCharsets.UTF_8), mode, 0, lastModified, (int)rawMerged.length(), attributes.get("merge"));
        }
        finally {
            if (rawMerged != null) {
                rawMerged.destroy();
            }
        }
    }

    private File writeMergedFile(TemporaryBuffer rawMerged, Attributes attributes) throws IOException {
        File workTree = this.nonNullRepo().getWorkTree();
        String gitPath = this.tw.getPathString();
        File of = new File(workTree, gitPath);
        CoreConfig.EolStreamType eol = this.workTreeUpdater.detectCheckoutStreamType(attributes);
        this.workTreeUpdater.updateFileWithContent(rawMerged::openInputStream, eol, this.tw.getSmudgeCommand(attributes), gitPath, of);
        return of;
    }

    private TemporaryBuffer doMerge(MergeResult<RawText> result) throws IOException {
        TemporaryBuffer.LocalFile buf = new TemporaryBuffer.LocalFile(this.db != null ? this.nonNullRepo().getDirectory() : null, this.workTreeUpdater.getInCoreFileSizeLimit());
        boolean success = false;
        try {
            new MergeFormatter().formatMerge(buf, result, Arrays.asList(this.commitNames), StandardCharsets.UTF_8);
            buf.close();
            success = true;
        }
        finally {
            if (!success) {
                buf.destroy();
            }
        }
        return buf;
    }

    private int mergeFileModes(int modeB, int modeO, int modeT) {
        if (modeO == modeT) {
            return modeO;
        }
        if (modeB == modeO) {
            return modeT == FileMode.MISSING.getBits() ? modeO : modeT;
        }
        if (modeB == modeT) {
            return modeO == FileMode.MISSING.getBits() ? modeT : modeO;
        }
        return FileMode.MISSING.getBits();
    }

    private RawText getRawText(ObjectId id, Attributes attributes) throws IOException, BinaryBlobException {
        if (id.equals(ObjectId.zeroId())) {
            return new RawText(new byte[0]);
        }
        ObjectLoader loader = LfsFactory.getInstance().applySmudgeFilter(this.getRepository(), this.reader.open(id, 3), attributes.get("merge"));
        int threshold = 0x3200000;
        return RawText.load(loader, threshold);
    }

    private static boolean nonTree(int mode) {
        return mode != 0 && !FileMode.TREE.equals(mode);
    }

    private static boolean isGitLink(int mode) {
        return FileMode.GITLINK.equals(mode);
    }

    @Override
    public ObjectId getResultTreeId() {
        return this.resultTree == null ? null : this.resultTree.toObjectId();
    }

    public void setCommitNames(String[] commitNames) {
        this.commitNames = commitNames;
    }

    public String[] getCommitNames() {
        return this.commitNames;
    }

    public List<String> getUnmergedPaths() {
        return this.unmergedPaths;
    }

    public List<String> getModifiedFiles() {
        return this.workTreeUpdater != null ? this.workTreeUpdater.getModifiedFiles() : this.modifiedFiles;
    }

    public Map<String, DirCacheEntry> getToBeCheckedOut() {
        return this.workTreeUpdater.getToBeCheckedOut();
    }

    public Map<String, MergeResult<? extends Sequence>> getMergeResults() {
        return this.mergeResults;
    }

    public Map<String, MergeFailureReason> getFailingPaths() {
        return this.failingPaths.isEmpty() ? null : this.failingPaths;
    }

    public boolean failed() {
        return !this.failingPaths.isEmpty();
    }

    public void setDirCache(DirCache dc) {
        this.dircache = dc;
    }

    public void setWorkingTreeIterator(WorkingTreeIterator workingTreeIterator) {
        this.workingTreeIterator = workingTreeIterator;
    }

    public void setAttributesNodeProvider(AttributesNodeProvider attributesNodeProvider) {
        this.attributesNodeProvider = attributesNodeProvider;
    }

    protected boolean mergeTrees(AbstractTreeIterator baseTree, RevTree headTree, RevTree mergeTree, boolean ignoreConflicts) throws IOException {
        try {
            this.workTreeUpdater = this.inCore ? WorkTreeUpdater.createInCoreWorkTreeUpdater(this.db, this.dircache, this.getObjectInserter()) : WorkTreeUpdater.createWorkTreeUpdater(this.db, this.dircache);
            this.dircache = this.workTreeUpdater.getLockedDirCache();
            this.tw = new NameConflictTreeWalk(this.db, this.reader);
            if (this.attributesNodeProvider != null) {
                this.tw.setAttributesNodeProvider(this.attributesNodeProvider);
            }
            this.tw.addTree(baseTree);
            this.tw.setHead(this.tw.addTree(headTree));
            this.tw.addTree(mergeTree);
            DirCacheBuildIterator buildIt = this.workTreeUpdater.createDirCacheBuildIterator();
            int dciPos = this.tw.addTree(buildIt);
            if (this.workingTreeIterator != null) {
                this.tw.addTree(this.workingTreeIterator);
                this.workingTreeIterator.setDirCacheIterator(this.tw, dciPos);
            } else {
                this.tw.setFilter(TreeFilter.ANY_DIFF);
            }
            if (!this.mergeTreeWalk(this.tw, ignoreConflicts)) {
                return false;
            }
            this.workTreeUpdater.writeWorkTreeChanges(true);
            if (this.getUnmergedPaths().isEmpty() && !this.failed()) {
                WorkTreeUpdater.Result result = this.workTreeUpdater.writeIndexChanges();
                this.resultTree = result.getTreeId();
                this.modifiedFiles = result.getModifiedFiles();
                for (String f : result.getFailedToDelete()) {
                    this.failingPaths.put(f, MergeFailureReason.COULD_NOT_DELETE);
                }
                boolean bl = result.getFailedToDelete().isEmpty();
                return bl;
            }
            this.resultTree = null;
            return false;
        }
        finally {
            if (this.modifiedFiles.isEmpty()) {
                this.modifiedFiles = this.workTreeUpdater.getModifiedFiles();
            }
            this.workTreeUpdater.close();
            this.workTreeUpdater = null;
        }
    }

    protected boolean mergeTreeWalk(TreeWalk treeWalk, boolean ignoreConflicts) throws IOException {
        boolean hasWorkingTreeIterator = this.tw.getTreeCount() > 4;
        boolean hasAttributeNodeProvider = treeWalk.getAttributesNodeProvider() != null;
        while (treeWalk.next()) {
            Attributes[] attributes = new Attributes[]{NO_ATTRIBUTES, NO_ATTRIBUTES, NO_ATTRIBUTES};
            if (hasAttributeNodeProvider) {
                attributes[0] = treeWalk.getAttributes(0);
                attributes[1] = treeWalk.getAttributes(1);
                attributes[2] = treeWalk.getAttributes(2);
            }
            if (!this.processEntry(treeWalk.getTree(0, CanonicalTreeParser.class), treeWalk.getTree(1, CanonicalTreeParser.class), treeWalk.getTree(2, CanonicalTreeParser.class), treeWalk.getTree(3, DirCacheBuildIterator.class), hasWorkingTreeIterator ? treeWalk.getTree(4, WorkingTreeIterator.class) : null, ignoreConflicts, attributes)) {
                this.workTreeUpdater.revertModifiedFiles();
                return false;
            }
            if (!treeWalk.isSubtree() || !this.enterSubtree) continue;
            treeWalk.enterSubtree();
        }
        return true;
    }

    public static enum MergeFailureReason {
        DIRTY_INDEX,
        DIRTY_WORKTREE,
        COULD_NOT_DELETE;

    }

    protected static class WorkTreeUpdater
    implements Closeable {
        Result result = new Result();
        @Nullable
        private final Repository repo;
        private final boolean inCore;
        private final ObjectInserter inserter;
        private final ObjectReader reader;
        private DirCache dirCache;
        private boolean implicitDirCache = false;
        private DirCacheBuilder builder;
        private WorkingTreeOptions workingTreeOptions;
        private int inCoreFileSizeLimit;
        private final Map<String, DirCacheEntry> toBeCheckedOut = new HashMap<String, DirCacheEntry>();
        private final TreeMap<String, File> toBeDeleted = new TreeMap();
        private Map<String, DirCacheCheckout.CheckoutMetadata> checkoutMetadataByPath;
        private Map<String, DirCacheCheckout.CheckoutMetadata> cleanupMetadataByPath;
        private boolean indexChangesWritten;
        private Checkout checkout;

        private WorkTreeUpdater(Repository repo, DirCache dirCache) {
            this.repo = repo;
            this.dirCache = dirCache;
            this.inCore = false;
            this.inserter = repo.newObjectInserter();
            this.reader = this.inserter.newReader();
            StoredConfig config = repo.getConfig();
            this.workingTreeOptions = config.get(WorkingTreeOptions.KEY);
            this.inCoreFileSizeLimit = WorkTreeUpdater.getInCoreFileSizeLimit(config);
            this.checkoutMetadataByPath = new HashMap<String, DirCacheCheckout.CheckoutMetadata>();
            this.cleanupMetadataByPath = new HashMap<String, DirCacheCheckout.CheckoutMetadata>();
            this.checkout = new Checkout(this.nonNullRepo(), this.workingTreeOptions);
        }

        public static WorkTreeUpdater createWorkTreeUpdater(Repository repo, DirCache dirCache) {
            return new WorkTreeUpdater(repo, dirCache);
        }

        private WorkTreeUpdater(Repository repo, DirCache dirCache, ObjectInserter oi) {
            this.repo = repo;
            this.dirCache = dirCache;
            this.inserter = oi;
            this.inCore = true;
            this.reader = oi.newReader();
            if (repo != null) {
                this.inCoreFileSizeLimit = WorkTreeUpdater.getInCoreFileSizeLimit(repo.getConfig());
            }
        }

        public static WorkTreeUpdater createInCoreWorkTreeUpdater(Repository repo, DirCache dirCache, ObjectInserter oi) {
            return new WorkTreeUpdater(repo, dirCache, oi);
        }

        private static int getInCoreFileSizeLimit(Config config) {
            return config.getInt("merge", "inCoreLimit", 0xA00000);
        }

        public int getInCoreFileSizeLimit() {
            return this.inCoreFileSizeLimit;
        }

        public DirCache getLockedDirCache() throws IOException {
            if (this.dirCache == null) {
                this.implicitDirCache = true;
                this.dirCache = this.inCore ? DirCache.newInCore() : this.nonNullRepo().lockDirCache();
            }
            if (this.builder == null) {
                this.builder = this.dirCache.builder();
            }
            return this.dirCache;
        }

        public DirCacheBuildIterator createDirCacheBuildIterator() {
            return new DirCacheBuildIterator(this.builder);
        }

        public void writeWorkTreeChanges(boolean shouldCheckoutTheirs) throws IOException {
            this.handleDeletedFiles();
            if (this.inCore) {
                this.builder.finish();
                return;
            }
            if (shouldCheckoutTheirs) {
                this.checkout();
            }
            if (!this.builder.commit()) {
                this.revertModifiedFiles();
                throw new IndexWriteException();
            }
        }

        public Result writeIndexChanges() throws IOException {
            this.result.treeId = this.getLockedDirCache().writeTree(this.inserter);
            this.indexChangesWritten = true;
            return this.result;
        }

        public void addToCheckout(String path, DirCacheEntry entry, CoreConfig.EolStreamType cleanupStreamType, String cleanupSmudgeCommand, CoreConfig.EolStreamType checkoutStreamType, String checkoutSmudgeCommand) {
            if (entry != null) {
                this.toBeCheckedOut.put(path, entry);
            }
            this.addCheckoutMetadata(this.cleanupMetadataByPath, path, cleanupStreamType, cleanupSmudgeCommand);
            this.addCheckoutMetadata(this.checkoutMetadataByPath, path, checkoutStreamType, checkoutSmudgeCommand);
        }

        public Map<String, DirCacheEntry> getToBeCheckedOut() {
            return this.toBeCheckedOut;
        }

        public void deleteFile(String path, File file, CoreConfig.EolStreamType streamType, String smudgeCommand) {
            this.toBeDeleted.put(path, file);
            if (file != null && file.isFile()) {
                this.addCheckoutMetadata(this.cleanupMetadataByPath, path, streamType, smudgeCommand);
            }
        }

        private void addCheckoutMetadata(Map<String, DirCacheCheckout.CheckoutMetadata> map, String path, CoreConfig.EolStreamType streamType, String smudgeCommand) {
            if (this.inCore || map == null) {
                return;
            }
            map.put(path, new DirCacheCheckout.CheckoutMetadata(streamType, smudgeCommand));
        }

        public CoreConfig.EolStreamType detectCheckoutStreamType(Attributes attributes) {
            if (this.inCore) {
                return null;
            }
            return EolStreamTypeUtil.detectStreamType(TreeWalk.OperationType.CHECKOUT_OP, this.workingTreeOptions, attributes);
        }

        private void handleDeletedFiles() {
            for (String path : this.toBeDeleted.descendingKeySet()) {
                File file;
                File file2 = file = this.inCore ? null : this.toBeDeleted.get(path);
                if (file == null || file.delete() || file.isDirectory()) continue;
                this.result.failedToDelete.add(path);
            }
        }

        public void markAsModified(String path) {
            this.result.modifiedFiles.add(path);
        }

        public List<String> getModifiedFiles() {
            return this.result.modifiedFiles;
        }

        private void checkout() throws NoWorkTreeException, IOException {
            for (Map.Entry<String, DirCacheEntry> entry : this.toBeCheckedOut.entrySet()) {
                DirCacheEntry dirCacheEntry = entry.getValue();
                String gitPath = entry.getKey();
                if (dirCacheEntry.getFileMode() == FileMode.GITLINK) {
                    this.checkout.checkoutGitlink(dirCacheEntry, gitPath);
                    continue;
                }
                this.checkout.checkout(dirCacheEntry, this.checkoutMetadataByPath.get(gitPath), this.reader, gitPath);
                this.result.modifiedFiles.add(gitPath);
            }
        }

        public void revertModifiedFiles() throws IOException {
            if (this.inCore) {
                this.result.modifiedFiles.clear();
                return;
            }
            if (this.indexChangesWritten) {
                return;
            }
            for (String path : this.result.modifiedFiles) {
                DirCacheEntry entry = this.dirCache.getEntry(path);
                if (entry == null) continue;
                this.checkout.checkout(entry, this.cleanupMetadataByPath.get(path), this.reader, path);
            }
        }

        @Override
        public void close() throws IOException {
            if (this.implicitDirCache) {
                this.dirCache.unlock();
            }
        }

        public void updateFileWithContent(DirCacheCheckout.StreamSupplier inputStream, CoreConfig.EolStreamType streamType, String smudgeCommand, String path, File file) throws IOException {
            if (this.inCore) {
                return;
            }
            this.checkout.safeCreateParentDirectory(path, file.getParentFile(), false);
            DirCacheCheckout.CheckoutMetadata metadata = new DirCacheCheckout.CheckoutMetadata(streamType, smudgeCommand);
            Throwable throwable = null;
            Object var8_9 = null;
            try (FileOutputStream outputStream = new FileOutputStream(file);){
                DirCacheCheckout.getContent(this.repo, path, metadata, inputStream, this.workingTreeOptions, (OutputStream)outputStream);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        public DirCacheEntry insertToIndex(InputStream input, byte[] path, FileMode fileMode, int entryStage, Instant lastModified, int len, Attribute lfsAttribute) throws IOException {
            return this.addExistingToIndex(this.insertResult(input, lfsAttribute, len), path, fileMode, entryStage, lastModified, len);
        }

        public DirCacheEntry addExistingToIndex(ObjectId objectId, byte[] path, FileMode fileMode, int entryStage, Instant lastModified, int len) {
            DirCacheEntry dce = new DirCacheEntry(path, entryStage);
            dce.setFileMode(fileMode);
            if (lastModified != null) {
                dce.setLastModified(lastModified);
            }
            dce.setLength(this.inCore ? 0 : len);
            dce.setObjectId(objectId);
            this.builder.add(dce);
            return dce;
        }

        private ObjectId insertResult(InputStream input, Attribute lfsAttribute, long length) throws IOException {
            Throwable throwable = null;
            Object var6_6 = null;
            try (LfsFactory.LfsInputStream is = LfsFactory.getInstance().applyCleanFilter(this.repo, input, length, lfsAttribute);){
                return this.inserter.insert(3, is.getLength(), is);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @NonNull
        private Repository nonNullRepo() throws NullPointerException {
            return Objects.requireNonNull(this.repo, () -> JGitText.get().repositoryIsRequired);
        }

        public static class Result {
            private final List<String> modifiedFiles = new ArrayList<String>();
            private final List<String> failedToDelete = new ArrayList<String>();
            private ObjectId treeId = null;

            public ObjectId getTreeId() {
                return this.treeId;
            }

            public List<String> getFailedToDelete() {
                return this.failedToDelete;
            }

            public List<String> getModifiedFiles() {
                return this.modifiedFiles;
            }
        }
    }
}

