/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.form;

import com.jeta.forms.components.panel.FormPanel;
import com.jeta.forms.gui.beans.DynamicBeanInfo;
import com.jeta.forms.gui.beans.JETABean;
import com.jeta.forms.gui.beans.JETABeanFactory;
import com.jeta.forms.gui.beans.JETAPropertyDescriptor;
import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponentFactory;
import com.jeta.forms.gui.form.GridComponent;
import com.jeta.forms.gui.form.GridView;
import com.jeta.forms.gui.form.ReadOnlyConstraints;
import com.jeta.forms.gui.form.StandardComponent;
import com.jeta.forms.gui.formmgr.FormManager;
import com.jeta.forms.gui.formmgr.FormManagerUtils;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.bean.BeanSerializerFactory;
import com.jeta.forms.store.memento.BeanMemento;
import com.jeta.forms.store.memento.CellConstraintsMemento;
import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.FocusPolicyMemento;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import com.jeta.forms.store.memento.StateRequest;
import com.jeta.open.registry.JETARegistry;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Window;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.swing.JLabel;

public class FormComponent
extends GridComponent {
    private String m_id;
    private boolean m_embedded = false;
    private String m_abspath = null;
    private boolean m_top_level_form = false;
    private FocusPolicyMemento m_focus_policy;
    static /* synthetic */ Class class$com$jeta$forms$gui$form$StandardComponent;

    protected FormComponent() {
    }

    protected FormComponent(String string, JETABean jETABean, GridView gridView, boolean bl) throws FormException {
        super(jETABean, gridView);
        this.m_id = string;
        FormUtils.safeAssert(jETABean.getDelegate() instanceof GridView);
        this.setBean(this.getBean());
        this.m_embedded = bl;
    }

    public static FormComponent create() {
        FormComponentFactory formComponentFactory = (FormComponentFactory)JETARegistry.lookup("form.component.factory");
        if (formComponentFactory == null) {
            FormUtils.safeAssert(!FormUtils.isDesignMode());
            return new FormComponent();
        }
        return formComponentFactory.createFormComponent();
    }

    public String getAbsolutePath() {
        return this.m_abspath;
    }

    public int getCellWidth() {
        if (this.getParentView() == null) {
            return this.getWidth();
        }
        return super.getCellWidth();
    }

    public int getCellHeight() {
        if (this.getParentView() == null) {
            return this.getHeight();
        }
        return super.getCellHeight();
    }

    public int getCellX() {
        if (this.getParentView() == null) {
            return this.getX();
        }
        return super.getCellX();
    }

    public int getCellY() {
        if (this.getParentView() == null) {
            return this.getY();
        }
        return super.getCellY();
    }

    public GridView getChildView() {
        JETABean jETABean = this.getBean();
        if (jETABean != null) {
            return (GridView)jETABean.getDelegate();
        }
        return null;
    }

    public int getColumnCount() {
        GridView gridView = this.getChildView();
        return gridView == null ? 0 : gridView.getColumnCount();
    }

    public String getFileName() {
        String string;
        if (this.isLinked() && (string = this.getAbsolutePath()) != null) {
            int n = string.lastIndexOf(47);
            if (n < 0) {
                n = string.lastIndexOf(92);
            }
            if (n >= 0) {
                return string.substring(n + 1, string.length());
            }
            return string;
        }
        return null;
    }

    public FocusPolicyMemento getFocusPolicy() {
        return this.m_focus_policy;
    }

    public GridComponent getGridComponent(int n, int n2) {
        GridView gridView = this.getChildView();
        return gridView == null ? null : gridView.getGridComponent(n, n2);
    }

    public static FormComponent getParentForm(Component component) {
        if (component == null) {
            return null;
        }
        for (component = component.getParent(); component != null; component = component.getParent()) {
            if (!(component instanceof FormComponent)) continue;
            return (FormComponent)component;
        }
        return null;
    }

    public FormComponent getParentForm() {
        return FormComponent.getParentForm(this);
    }

    public GridComponent getSelectedComponent() {
        if (this.isSelected()) {
            return this;
        }
        return this.getChildView().getSelectedComponent();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FormMemento getExternalState(StateRequest stateRequest) throws FormException {
        try {
            JETARegistry.rebind("state.request", stateRequest);
            this.setTopLevelForm(true);
            FormMemento formMemento = (FormMemento)this.getState(stateRequest);
            return formMemento;
        }
        finally {
            this.setTopLevelForm(false);
            JETARegistry.rebind("state.request", null);
        }
    }

    public int getRowCount() {
        GridView gridView = this.getChildView();
        return gridView == null ? 0 : gridView.getRowCount();
    }

    public ComponentMemento getState(StateRequest stateRequest) throws FormException {
        Object object;
        Object object2;
        FormMemento formMemento = new FormMemento();
        GridView gridView = this.getChildView();
        formMemento.setId(this.getId());
        formMemento.setComponentClass(FormComponent.class.getName());
        formMemento.setFocusPolicy(this.m_focus_policy);
        if (this.getParentView() != null) {
            formMemento.setCellConstraints(this.getConstraints().createCellConstraints());
        }
        if (this.isLinked() && stateRequest.isShallowCopy()) {
            formMemento.setRelativePath(this.getRelativePath());
            if (!this.isTopLevelForm()) {
                return formMemento;
            }
        }
        formMemento.setRowGroups(gridView.getRowGroups());
        formMemento.setColumnGroups(gridView.getColumnGroups());
        formMemento.setRowSpecs(gridView.getRowSpecs());
        formMemento.setColumnSpecs(gridView.getColumnSpecs());
        formMemento.setCellPainters(gridView.getCellPainters());
        Iterator iterator = gridView.gridIterator();
        while (iterator.hasNext()) {
            object2 = (GridComponent)iterator.next();
            if (((GridComponent)object2).getBean() == null) continue;
            object = ((GridComponent)object2).getState(stateRequest);
            formMemento.addComponent((ComponentMemento)object);
        }
        object2 = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
        object = object2.createSerializer();
        JETABean jETABean = this.getBean();
        FormUtils.safeAssert(jETABean.getDelegate() == gridView);
        PropertiesMemento propertiesMemento = object.writeBean(jETABean);
        formMemento.setPropertiesMemento(propertiesMemento);
        return formMemento;
    }

    public String getId() {
        if (this.isEmbedded()) {
            if (this.m_id == null) {
                this.m_id = "embedded." + String.valueOf(this.hashCode());
            }
            return this.m_id;
        }
        if (this.m_abspath == null) {
            if (this.m_id == null) {
                this.m_id = "linked." + String.valueOf(this.hashCode());
            }
            return this.m_id;
        }
        return this.m_abspath;
    }

    public String getRelativePath() {
        ProjectManager projectManager = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
        return projectManager.getRelativePath(this.m_abspath);
    }

    public static FormComponent getTopLevelForm(Component component) {
        if (component == null) {
            return null;
        }
        while (component != null && !(component instanceof Window)) {
            if (component instanceof FormComponent && ((FormComponent)component).isTopLevelForm()) {
                return (FormComponent)component;
            }
            component = component.getParent();
        }
        return null;
    }

    public boolean isEmbedded() {
        return this.m_embedded;
    }

    public boolean isLinked() {
        return !this.isEmbedded();
    }

    public Iterator gridIterator() {
        return this.getChildView().gridIterator();
    }

    public boolean isTopLevelForm() {
        return this.m_top_level_form;
    }

    protected FormComponent openLinkedForm(FormMemento formMemento) throws FormException {
        FormComponent formComponent = FormManagerUtils.openPackagedForm(formMemento.getRelativePath());
        return formComponent;
    }

    public void _postInitialize(FormPanel formPanel, Container container) {
        if (container == null) {
            return;
        }
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            if (component instanceof GridComponent) {
                ((GridComponent)component).postInitialize(formPanel);
                continue;
            }
            if (!(component instanceof Container)) continue;
            this._postInitialize(formPanel, (Container)component);
        }
    }

    public void postInitialize(FormPanel formPanel) {
        this._postInitialize(formPanel, this);
    }

    protected void postSetState(ComponentMemento componentMemento) {
        GridComponent gridComponent;
        int n;
        int n2;
        GridView gridView = this.getChildView();
        block0: for (n2 = 1; n2 <= gridView.getColumnCount(); ++n2) {
            for (n = 1; n <= gridView.getRowCount(); ++n) {
                gridComponent = gridView.getGridComponent(n2, n);
                if (gridComponent != null) continue;
                gridComponent = new StandardComponent(null, gridView);
                gridComponent.setPreferredSize(new Dimension(10, 10));
                gridComponent.setMinimumSize(new Dimension(10, 10));
                gridView.addComponent(gridComponent, new ReadOnlyConstraints(n2, n));
                continue block0;
            }
        }
        block2: for (n2 = 2; n2 <= gridView.getRowCount(); ++n2) {
            for (n = 1; n <= gridView.getColumnCount(); ++n) {
                gridComponent = gridView.getGridComponent(n, n2);
                if (gridComponent != null) continue;
                gridComponent = new StandardComponent(null, gridView);
                gridComponent.setPreferredSize(new Dimension(10, 10));
                gridComponent.setMinimumSize(new Dimension(10, 10));
                gridView.addComponent(gridComponent, new ReadOnlyConstraints(n, n2));
                continue block2;
            }
        }
    }

    public void print() {
        FormsLogger.debug("FormComponent  name = " + this.getName() + "   uid = " + this.getId() + "  path = " + this.getAbsolutePath() + "  hash: " + this.hashCode() + "   parentView: " + this.getParentView());
    }

    public void revalidate() {
        GridView gridView = this.getChildView();
        if (gridView != null) {
            gridView.revalidate();
        }
        super.revalidate();
    }

    protected void setBean(JETABean jETABean) {
        super.setBean(jETABean);
        FormUtils.safeAssert(jETABean.getDelegate() instanceof GridView);
        this.setLayout(new BorderLayout());
        FormUtils.safeAssert(this.getComponentCount() == 0);
        this.removeAll();
        this.add((Component)jETABean, "Center");
    }

    public void setAbsolutePath(String string) {
        this.m_abspath = string;
        if (string != null) {
            this.m_embedded = false;
        }
    }

    public void setControlButtonsVisible(boolean bl) {
    }

    public void setFocusPolicy(FocusPolicyMemento focusPolicyMemento) {
        this.m_focus_policy = focusPolicyMemento;
    }

    public void setSelected(boolean bl) {
        super.setSelected(bl);
        if (!bl) {
            GridView gridView = this.getChildView();
            gridView.deselectAll();
        }
    }

    public void setState(ComponentMemento componentMemento) throws FormException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        FormMemento formMemento = (FormMemento)componentMemento;
        if (formMemento.getRelativePath() == null) {
            this.m_embedded = true;
        }
        this.m_focus_policy = formMemento.getFocusPolicy();
        FormManager formManager = (FormManager)JETARegistry.lookup("jeta.forms.formmanager");
        if (FormUtils.isDesignMode()) {
            FormUtils.safeAssert(formManager != null);
        }
        JETABean jETABean = JETABeanFactory.createBean("com.jeta.forms.gui.form.GridView", "gridview", true, true);
        GridView gridView = (GridView)jETABean.getDelegate();
        gridView.initialize(formMemento.getColumnSpecs(), formMemento.getRowSpecs());
        gridView.setCellPainters(formMemento.getCellPainters());
        this.setBean(jETABean);
        gridView.setRowGroups(formMemento.getRowGroups());
        gridView.setColumnGroups(formMemento.getColumnGroups());
        PropertiesMemento propertiesMemento = formMemento.getPropertiesMemento();
        if (propertiesMemento != null) {
            object6 = (BeanSerializerFactory)JETARegistry.lookup("bean.serializer.factory");
            object5 = object6.createDeserializer(propertiesMemento);
            object5.initializeBean(jETABean);
        } else {
            try {
                object6 = formMemento.getProperties();
                object5 = jETABean.getBeanInfo();
                object4 = ((DynamicBeanInfo)object5).getPropertyDescriptors();
                object3 = object4.iterator();
                while (object3.hasNext()) {
                    object2 = (JETAPropertyDescriptor)object3.next();
                    object = ((HashMap)object6).get(object2.getName());
                    if (object == null) continue;
                    object2.setPropertyValue(jETABean, object);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        object6 = formMemento.iterator();
        while (object6.hasNext()) {
            object5 = (ComponentMemento)object6.next();
            try {
                if (object5 instanceof FormMemento && ((FormMemento)(object4 = (FormMemento)object5)).getRelativePath() != null) {
                    try {
                        object3 = this.openLinkedForm((FormMemento)object4);
                        gridView.addComponent((GridComponent)object3, ((ComponentMemento)object4).getCellConstraintsMemento().createCellConstraints());
                    }
                    catch (Exception exception) {
                        object2 = new JLabel("Error: " + ((FormMemento)object4).getRelativePath());
                        ((JComponent)object2).setForeground(Color.red);
                        object = new JETABean((Component)object2);
                        StandardComponent standardComponent = new StandardComponent((JETABean)object, gridView);
                        gridView.addComponent((GridComponent)standardComponent, ((ComponentMemento)object4).getCellConstraintsMemento().createCellConstraints());
                        FormsLogger.severe(exception);
                    }
                    continue;
                }
                object4 = ((ComponentMemento)object5).getCellConstraintsMemento();
                if ((class$com$jeta$forms$gui$form$StandardComponent == null ? FormComponent.class$("com.jeta.forms.gui.form.StandardComponent") : class$com$jeta$forms$gui$form$StandardComponent).getName().equals(((ComponentMemento)object5).getComponentClass()) && object5 instanceof BeanMemento && ((BeanMemento)(object3 = (BeanMemento)object5)).getBeanClass() == null) continue;
                object3 = null;
                object2 = Class.forName(((ComponentMemento)object5).getComponentClass());
                object3 = (class$com$jeta$forms$gui$form$FormComponent == null ? FormComponent.class$("com.jeta.forms.gui.form.FormComponent") : class$com$jeta$forms$gui$form$FormComponent).isAssignableFrom((Class<?>)object2) ? FormComponent.create() : (GridComponent)((Class)object2).newInstance();
                ((GridComponent)object3).setState((ComponentMemento)object5);
                if (object4 == null) {
                    System.out.println("FormComponent.setState cellconstraints memento is null: ");
                    ((GridComponent)object3).print();
                    FormUtils.safeAssert(false);
                    continue;
                }
                gridView.addComponent((GridComponent)object3, ((CellConstraintsMemento)object4).createCellConstraints());
            }
            catch (Exception exception) {
                FormsLogger.severe(exception);
            }
        }
        this.postSetState(componentMemento);
        gridView.refreshView();
    }

    public void setTopLevelForm(boolean bl) {
        this.m_top_level_form = bl;
    }
}

