/*
 * Decompiled with CFR 0.152.
 */
package com.xebialabs.deployit.core;

import com.xebialabs.deployit.core.AbstractStringView;
import com.xebialabs.deployit.core.EncryptedStringValue;
import com.xebialabs.deployit.core.StringValue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class ListOfStringView
extends AbstractStringView<List<StringValue>>
implements List<String> {
    public ListOfStringView() {
        super(new ArrayList());
    }

    public ListOfStringView(List<StringValue> wrapped) {
        super(wrapped);
    }

    public ListOfStringView encrypt() {
        return new ListOfStringView(((List)this.wrapped).stream().map(StringValue::encrypt).collect(Collectors.toList()));
    }

    @Override
    public boolean addAll(int index, Collection<? extends String> c) {
        return ((List)this.getWrapped()).addAll(index, this.transformToStringValue(c));
    }

    @Override
    public String get(int index) {
        return ((StringValue)((List)this.getWrapped()).get(index)).toString();
    }

    @Override
    public String set(int index, String element) {
        return this._set(index, new StringValue(element));
    }

    public String setEncrypted(int index, String element) {
        return this._set(index, new EncryptedStringValue(element));
    }

    private String _set(int index, StringValue e) {
        StringValue set = ((List)this.getWrapped()).set(index, e);
        return set == null ? null : set.toString();
    }

    @Override
    public void add(int index, String element) {
        ((List)this.getWrapped()).add(index, new StringValue(element));
    }

    public void addEncrypted(int index, String element) {
        ((List)this.getWrapped()).add(index, new EncryptedStringValue(element));
    }

    @Override
    public String remove(int index) {
        return ((StringValue)((List)this.getWrapped()).remove(index)).toString();
    }

    @Override
    public int indexOf(Object o) {
        return ((List)this.getWrapped()).indexOf(this.stringToStringValue(o));
    }

    @Override
    public int lastIndexOf(Object o) {
        return ((List)this.getWrapped()).lastIndexOf(this.stringToStringValue(o));
    }

    @Override
    public ListIterator<String> listIterator() {
        return new TransformingListIterator(((List)this.getWrapped()).listIterator());
    }

    @Override
    public ListIterator<String> listIterator(int index) {
        return new TransformingListIterator(((List)this.getWrapped()).listIterator(index));
    }

    @Override
    public List<String> subList(int fromIndex, int toIndex) {
        return new ListOfStringView(((List)this.getWrapped()).subList(fromIndex, toIndex));
    }

    public static ListOfStringView from(List<String> strings) {
        if (strings instanceof ListOfStringView) {
            return (ListOfStringView)strings;
        }
        ListOfStringView stringView = new ListOfStringView();
        if (strings != null) {
            stringView.addAll((Collection<? extends String>)strings);
        }
        return stringView;
    }

    public static ListOfStringView copy(List<String> strings) {
        if (strings instanceof ListOfStringView) {
            return new ListOfStringView((List<StringValue>)new ArrayList<StringValue>((Collection<StringValue>)((ListOfStringView)strings).getWrapped()));
        }
        return ListOfStringView.from(strings);
    }

    private static class TransformingListIterator
    implements ListIterator<String> {
        private ListIterator<StringValue> wrappedIterator;

        private TransformingListIterator(ListIterator<StringValue> wrappedIterator) {
            this.wrappedIterator = wrappedIterator;
        }

        @Override
        public boolean hasNext() {
            return this.wrappedIterator.hasNext();
        }

        @Override
        public String next() {
            return this.wrappedIterator.next().toString();
        }

        @Override
        public boolean hasPrevious() {
            return this.wrappedIterator.hasPrevious();
        }

        @Override
        public String previous() {
            return this.wrappedIterator.previous().toString();
        }

        @Override
        public int nextIndex() {
            return this.wrappedIterator.nextIndex();
        }

        @Override
        public int previousIndex() {
            return this.wrappedIterator.previousIndex();
        }

        @Override
        public void remove() {
            this.wrappedIterator.remove();
        }

        @Override
        public void set(String s) {
            this.wrappedIterator.set(new StringValue(s));
        }

        @Override
        public void add(String s) {
            this.wrappedIterator.add(new StringValue(s));
        }
    }
}

